use bytes;
use strict;
use warnings;

my $bitsForIndex = 3;
my $lastIndex = -1;
my $n = 0;
my $output = "";
my $data = "";
my $index;

sub output() {
	if ($n != 0) {
#		printf STDERR ("output %d times %d\n", $n, $lastIndex);
		my $c = (($n - 1) << $bitsForIndex) | $lastIndex;
		die unless (0 <= $c && $c <= 255);
		$output .= chr($c);
	}
}

my $x;
while (sysread(STDIN, $x, 1) == 1) {
	if (index($data, $x) == -1) {
#		printf STDERR ("adding %s to data\n", unpack("H*", $x));
		$data .= $x;
	}
	$index = index($data, $x);

	if ($index != $lastIndex || $n == (1 << (8 - $bitsForIndex))) {
		output();
		$lastIndex = $index;
		$n = 0;
	}
	$n++;
}
output();

# don't record trailing zeros; dangerous, but works
$output =~ s/[\xf8\x78]*$//;

die "invalid data length" unless length($data) == 8;
syswrite(STDOUT, $data);
syswrite(STDOUT, pack("v", length($output)));
syswrite(STDOUT, $output);
