org 0100h

main:
	cld
	mov ax, 3
	int 10h
	push word 0B800h
	pop es

; paint the foreground from the RLE-encoded data.
	xor di, di
	mov bx, fg_data
	call paint_rle

; paint the background from the RLE-encoded data.
	mov di, 1
	mov bx, si
;	mov bx, bg_data		; unnecessary, since bg_data follows fg_data
	call paint_rle

; print the strings that didn't make it into the simplified data.
;	mov si, str_0		; unnecessary, since str_0 follows bg_data
	mov di, 0576h
	call print_string
;	mov si, str_1		; unnecessary, since str_1 follows str_0
	mov di, 07ach
	call print_string
;	mov si, str_2		; unnecessary, since str_2 follows str_1
	mov di, 0848h
	call print_string

; patch those places that didn't make it into the simplified data,
; using the data stored behind the strings.
	mov al, 0deh
	mov di, 04b2h
	stosb
	mov di, 04ceh
	stosb
	mov di, 056eh
	stosb
	mov di, 0c86h

	movsw
	movsw
	mov di, 0cefh
	lodsb
	stosb
	inc di
	stosb
	mov di, 0d1fh
	movsb

readkey:
	xchg ax, cx		; after a loop, cx is zero.
	int 16h
	ret			; [PSP:0000] contains cd 20.


; proc paint_rle
;
; input:
;	DS:BX	The RLE-encoded data to be extracted.
;			1. table of 8 characters
;			2. number of items
;			3. RLE-chunks, each one byte long
;	ES:DI	destination
;
; output:
;	AH	0
;	AL	the last byte that has been painted
;	BX	start of the RLE-encoded bytes
;	CX	0
;	DX	0
;	DS:SI	the byte after the last RLE chunk
;
paint_rle:
	lea si, [bx + 8]	; skip the character table

	lodsw
	xchg ax, dx		; get the number of RLE items
	
paint_rle_outer_loop:
	xor ax, ax		; load a byte and zero-extend it to
	lodsb			; a word.

	mov cx, ax		; extract the number of repetions.
	shr cx, 3
	inc cx

	and al, 07h		; and lookup the character in the
	xlat			; character table.

paint_rle_onechar:
	stosb			; when painting the foreground, leave
	inc di			; the background as-is, and vice versa.
	loop paint_rle_onechar

	dec dx
	jnz paint_rle_outer_loop

print_string_end:		; procedure tail optimization
	ret
; endproc paint_rle


; proc print_string
;
; input:
;	DS:SI	First, the background color of the string.
;		Then the characters of the string to be printed.
;	ES:DI	The destination where the string is printed.
;
; output:
;	DS:DI	The byte after the terminating NUL byte.
;	ES:DI	The position of the next character.
;	AL	0
;	AH	The background color of the string
;
print_string:
	lodsb
	mov ah, al

print_string_loop:
	lodsb
	test al, al
	jz print_string_end
	stosw
	jmp print_string_loop
; endproc print_string


fg_data:
incbin "fgsimple.rle"

bg_data:
incbin "bgsimple.rle"

str_0:	db 70h, 0feh, "Rest in  Peace", 0feh, 0
str_1:	db 0eh, "Happy", 0
str_2:	db 0eh, "Halloween!", 0

	dw 6073h
	dw 6063h
	db 'h'
	db 6fh
