BITS 16
ORG 0x100

SECTION .text

start:

;----------------------------------
; BEGIN CHARACTER DECODING SECTION
;----------------------------------
	les 	DI,[vid_origin]			; Load ES with Video RAM segment, set DI to zero (pointing
											;	at beginning of video memory)

	; NOTE: ripped next four lines from TESTER2.ASM, dunno why XP doesn't display text properly
	;		unless these are in here.  DOSBOX displays fine without these next four lines, though:
	mov	ax, 0013h		;force Windows into full-screen mode
	int	10h			;(Vista chokes on this)
	mov	ax, 0003h		;restore normal text mode with blink
	int	10h			; bit initialized to flash chars

	mov	SI, chardata				; Point source string ptr to be beginning of character data
	mov	CX, chardata_size			; Load CX with number of bytes of character data
decode_char_rle_loop:
	lodsb									; Load one byte of packed char data into AL
	mov	DH,AL							; Copy packed data to DH 
	and	DH, 00000111b				; Mask out non-RLE fields in DH
	shr	AL, 3							; Align 5-bit character hash index correctly in AL

	; TEST FOR SPECIAL-CASE CHARACTERS (ALLOW RUNLENGTHS 16-31 SPECIFIED IN SAME BYTE)
	cmp	AL, 26						; Special case of char 32
	je		special_case_01			
	cmp	AL, 27						; Special case of char 32
	je		special_case_10
	cmp	AL, 28						; Special case of char 32
	je		special_case_11
	cmp	AL, 29						; Special case of char 219
	je		special_case_01
	cmp	AL, 30						; Special case of char 219
	je		special_case_10
	cmp	AL, 31						; Special case of char 219
	je		special_case_11


	; TEST FOR NON-SPECIAL CHARACTERS THAT HAVE A SUFFIX BYTE FOR THE RUNLENGTH
	test	DH, DH						; If this isn't a special case character, see if a
											; 	suffix byte has been specified (0 in RLE field)
	jnz	decode_char					

	; GET SUFFIX BYTE
	xchg	AH, AL						; Store character in AH since we need to load another byte
	dec	CX								; We always keep track of how many bytes of data are left
	lodsb 								; Get RLE suffix byte in AL
	mov	DH, AL						; Move runlength value from suffix into DH where it belongs
	xchg	AL, AH						; Place character we moved to AH back in AL
	jmp decode_char					
	

special_case_01:
	or		DH, 00001000b				; Missing bits 4 & 3 of runlength are implied to be 0,1 
	jmp	decode_char
special_case_10:
	or		DH, 00010000b				; Missing bits 4 & 3 of runlength are implied to be 1,0
	jmp	decode_char
special_case_11:
	or		DH, 00011000b				; Missing bits 4 & 3 of runlength are implied to be 1,1

decode_char:
	; DECODE CHARACTER FROM HASH TABLE
	mov	BX, charhash				; Load pointer to beginning of hash table into BX for XLAT
	xlatb									; Load ASCII code at [BX+AL] for our character back into AL

	; PREPARE TO STORE ENTIRE RUN INTO VIDEO RAM
	push	CX								; CX is being used for the outer loop so we must save it
											;	before we start a sub-loop
	movzx	CX, DH						; Place runlength into CX for STOSW

	rep stosw							; Copy character in AX into video memory the number of
											; 	times specified by the RLE field. The attribute byte is
											;	junk but we'll take care of that later.  This saves
											;	us an additional "inc DI" instruction since RAM is
											;  an array of words, not bytes
	pop	CX								; Restore CX that is being used for outer loop

	loop	decode_char_rle_loop		; Get another packed character and optional suffix byte
											;	until we finish all of the data (CX would be zero)


;---------------------------------
; BEGIN ATTRIBUTE DECODING SECTION
;---------------------------------
	mov	DI, 1							; Jump back almost to the beginning of video RAM, but put in
											;	place to load attribute bytes instead of char bytes (ES is
											;	already loaded with correct segment	for video RAM)
											; NOTE: SI, source string ptr, already conveniently in-place
											;	at beginning of attribute data
	mov	CX, attrdata_size			; Load CX with number of bytes of attribute data
decode_attr_rle_loop:
	lodsb									; Load one byte of packed attribute data into AL
	mov	DH,AL							; Copy packed attribute to DH 
	and	DH, 00001111b				; Mask out non-RLE fields in DH
	shr	AL, 4							; Align 4-bit attribute hash index correctly in AL

	; TEST FOR SPECIAL-CASE ATTRIBUTES (ALLOW RUNLENGTHS 16-31 SPECIFIED IN SAME BYTE)
	cmp	AL, 12						; Special case of attributes 6,7,8,15 if  AL >= 12
	jae	special_attr_case		

	; TEST FOR NON-SPECIAL ATTRIBUTES THAT HAVE A SUFFIX BYTE FOR THE RUNLENGTH
	test	DH, DH						; If this isn't a special case attribute, see if a
											; 	suffix byte has been specified (0 in RLE field)
	jnz	decode_attr					

	; GET SUFFIX BYTE
	xchg	AH, AL						; Store attribute in AH since we need to load another byte
	dec	CX								; We always keep track of how many bytes of data are left
	lodsb 								; Get RLE suffix byte in AL
	mov	DH, AL						; Move runlength value from suffix into DH where it belongs
	xchg	AL, AH						; Place attribute we moved to AH back in AL
	jmp decode_attr
	

special_attr_case:
	or		DH, 00010000b				; Missing bit 4 of runlength is implied to be 1 

decode_attr:
	; DECODE ATTRIBUTE FROM HASH TABLE
	mov	BX, attrhash				; Load pointer to beginning of hash table into BX for XLAT
	xlatb									; Load ASCII code at [BX+AL] for our attribute back into AL

	; PREPARE TO STORE ENTIRE RUN INTO VIDEO RAM
write_attr_loop_begin:
	stosb									; Write decoded attribute byte into video ram		
	inc	DI								; Increment DI (since stosb doesn't skip past the 
											;	character byte)
	dec 	DH								; Decrement run counter
	jnz	write_attr_loop_begin	; Keep writing same attribute until we've completed the run

	loop	decode_attr_rle_loop		; Get another packed attribute and optional suffix byte
											;	until we finish all of the data (CX would be zero after
											;	being automatically decremented here by LOOP)
	
exit:
	mov	AH, 0			;wait for keystroke
	int	16h

	ret					;return to DOS


SECTION .data

vid_origin  dd      0B8000000H   ; Beginning of Video RAM on color VGA systems

; Note - could have saved two bytes here by overlapping the two entries the
;		hash tables share but didn't have the time.

charhash		db		32,33,72,80,82,97,99,101,105,108,110,111,112,	\
						115,116,119,121,176,177,178,219,220,221,222,223,254, 	\
						32,32,32,219,219,219
attrhash		db		6,7,8,14,15,96,104,111,112,118,120,127,6,7,8,15

chardata_size 	equ	591
chardata:
db 0xD0,0x91,0xD8,0xAA,0xEA,0xAA,0x00,0x30,0x91,0x89,0xD7,0xA9,0xEE,0xA9,0x00,0x2F
db 0x91,0x89,0x99,0x06,0x9A,0x89,0x05,0xEA,0xC2,0xA4,0xE0,0xAE,0xD8,0x92,0x01,0x99
db 0x03,0x92,0x99,0x03,0x91,0x89,0x04,0xA3,0xC1,0xAA,0xC1,0x01,0xA9,0xA2,0xA9,0xA2
db 0xDC,0xAA,0x02,0x89,0x92,0xA1,0xAB,0xC2,0xA1,0xAA,0xD3,0x99,0x91,0x89,0x92,0x01
db 0x89,0x91,0x06,0x91,0x05,0xC2,0xE8,0xC2,0xDA,0xA9,0x01,0x89,0x93,0x9A,0xA1,0x99
db 0xA6,0xAA,0xC2,0xA1,0xA9,0x02,0x89,0x05,0x91,0x99,0x93,0x99,0x91,0x07,0x8A,0x91
db 0xDE,0xAA,0xD1,0xA1,0x89,0x91,0x99,0xA1,0x91,0xA1,0x99,0xEC,0xA9,0xC1,0xA1,0x01
db 0x89,0x91,0x02,0x91,0x89,0x91,0x9A,0x89,0x01,0x92,0xD3,0x89,0xD9,0xA9,0xA6,0xA9
db 0x06,0x89,0x91,0x99,0xA2,0x99,0xEF,0xB1,0xA1,0x03,0x8A,0x91,0x01,0x89,0x91,0xA1
db 0x8A,0x91,0xE5,0xB9,0xA1,0xC2,0xA2,0xC2,0xA2,0x04,0xB9,0x89,0x91,0xF3,0xB1,0xA1
db 0x02,0x89,0x91,0x03,0x89,0x91,0xA1,0x8A,0x91,0xD4,0xC1,0xAA,0xA1,0xA9,0xD4,0xA1
db 0xAA,0xA2,0xAA,0xA4,0x03,0xB9,0xA1,0x91,0xA1,0xC9,0x21,0x39,0x69,0x71,0x01,0x41
db 0x51,0x02,0x19,0x39,0x29,0x31,0x39,0xC9,0xA2,0xB1,0xA1,0x01,0x89,0x05,0x99,0x91
db 0x99,0x91,0x89,0x91,0xD4,0xC1,0xA9,0xA5,0xAB,0x04,0xAA,0xA4,0xA9,0x02,0xC1,0xA5
db 0x02,0xA2,0x99,0xF3,0xB1,0xA1,0x07,0x99,0x01,0x99,0xA1,0x92,0xD4,0xC1,0x03,0xC1
db 0xF8,0xAA,0x01,0xC2,0xF3,0xB1,0xA1,0x07,0x91,0x01,0x99,0xA1,0x99,0x91,0xD2,0xAE
db 0x03,0xC1,0xF6,0x99,0x91,0xA1,0xAB,0xC1,0xA1,0xC1,0xA9,0xC2,0xA9,0x01,0xC1,0xE8
db 0xB1,0xA1,0x07,0x91,0x99,0xA1,0x01,0x99,0x91,0x07,0xA9,0xA2,0x11,0x29,0x62,0x81
db 0xA3,0xA9,0x03,0xF3,0x99,0x91,0x89,0xA2,0x01,0x89,0x91,0xAB,0x8A,0x91,0xA9,0xC1
db 0xA9,0xA7,0xB1,0xA1,0x07,0xA1,0x99,0xA1,0x89,0x9A,0x06,0xA2,0x11,0x29,0x4A,0x59
db 0x79,0x3A,0x51,0x09,0xA2,0x03,0xC1,0xF2,0x99,0x91,0x89,0xA1,0x89,0xA1,0x8B,0x91
db 0x8A,0x91,0xC2,0xA9,0xA7,0xB1,0xA1,0x06,0x9A,0x01,0x89,0x91,0xA1,0x99,0x06,0xA2
db 0x91,0xA2,0x9A,0xA1,0x99,0xA2,0x99,0xA1,0x99,0x05,0xC2,0x92,0xA1,0x99,0xEB,0x99
db 0x91,0x89,0xA2,0x8B,0xC2,0x01,0xAB,0xE9,0xB1,0xA1,0x06,0xA1,0x91,0x89,0x01,0x91
db 0xA1,0x99,0x06,0xA1,0x99,0x89,0x9A,0x91,0x99,0xA1,0x91,0x99,0xA1,0x99,0xA1,0x99
db 0x04,0xA9,0xA2,0x01,0xA3,0xC1,0x91,0xEA,0x99,0x91,0x89,0xA2,0xC1,0x01,0xEF,0xB1
db 0xA1,0x06,0x99,0x01,0xA1,0x92,0xA1,0x91,0x06,0x99,0x91,0x89,0x91,0x99,0x92,0x99
db 0x89,0x9A,0x91,0xA1,0x91,0x04,0x99,0xA1,0x99,0x91,0xA9,0xC1,0xA2,0x91,0xE9,0x99
db 0x91,0xA1,0xC1,0xAB,0xF0,0xB1,0xA1,0x05,0x99,0xA1,0x01,0x91,0x01,0x89,0x99,0x91
db 0x06,0x99,0x8B,0x91,0x89,0x92,0x89,0x93,0x99,0x91,0x04,0x91,0x99,0x91,0x89,0x9A
db 0xA9,0xC1,0x91,0xEA,0x99,0x91,0x89,0xAB,0x01,0xC4,0xEB,0xB1,0xA1,0x04,0x99,0xA1
db 0x01,0x99,0x8B,0x99,0x8A,0x05,0x91,0x89,0x01,0x8D,0x01,0x89,0x91,0x89,0x91,0x89
db 0x04,0x89,0x91,0x89,0x01,0x94,0x01,0xC2,0xE8,0x91,0x89,0x01,0xA2,0x02,0x8B,0x91
db 0xA9,0x01,0xC6,0xA3,0xB1,0xA1,0x03,0x9A,0x02,0x91,0x8A,0x01,0x99,0x91,0x8A,0x04
db 0x89,0x02,0x8B,0x01,0x89,0x01,0x8A,0x01,0x8A,0x04,0x8A,0x02,0x91,0x8B,0x06,0xC6
db 0xA4,0x8D,0xA1,0x8A,0x92,0xA3,0xAB,0x02,0xC1,0x01,0xA9,0x89,0x91,0x69,0x31,0x89
db 0x91,0x99,0xAC,0x8B,0xAB,0xD6,0xA8,0x17,0xC2,0xA8,0x16,0xC0,0x51,0x00,0xF0


attrdata_size 	equ	228
attrdata:
db 0x18,0x01,0xD0,0x3E,0x10,0x30,0x02,0x1F,0x30,0x10,0x10,0x2F,0x03,0x16,0x03,0x15
db 0x30,0x10,0xDB,0x23,0xD0,0xC3,0x3E,0xD6,0xA5,0x29,0x1B,0x08,0x16,0x01,0x15,0x3C
db 0xD3,0xA7,0x21,0xA2,0x2B,0x12,0x01,0x15,0x07,0x17,0x03,0xD6,0x42,0x18,0xA1,0x11
db 0xA3,0x21,0xA1,0x21,0xA1,0x21,0xA2,0x2C,0x11,0x0D,0x1B,0x01,0xD1,0x48,0x15,0xA4
db 0x22,0xA2,0xE0,0x11,0x22,0x0A,0xDD,0x4E,0xA3,0x22,0xA1,0xE2,0x11,0x21,0x0B,0x1C
db 0x45,0x1C,0x4E,0xA1,0x21,0xA2,0x80,0x10,0x24,0x11,0x01,0x15,0x06,0x1C,0xFF,0x22
db 0xA1,0xE5,0x17,0x06,0x1C,0x40,0x20,0xE7,0x17,0x06,0x1A,0x29,0xF7,0xB2,0x14,0x23
db 0x11,0x22,0x12,0x2B,0x17,0x06,0x17,0x23,0x35,0x27,0xF3,0xB3,0x12,0xA3,0x13,0xA3
db 0x12,0x2A,0x17,0x06,0x16,0x22,0x3A,0x25,0x46,0xB1,0x4C,0xB3,0x11,0xA1,0x11,0xA7
db 0x12,0x2A,0x16,0x07,0x16,0x2E,0x15,0x42,0xB6,0x49,0xB3,0x12,0xA3,0x13,0x2E,0x16
db 0x07,0x16,0xE6,0x13,0xB3,0x49,0xB3,0x14,0xE1,0x16,0x07,0x16,0xE7,0x13,0xB3,0x47
db 0xB2,0x12,0xE5,0x11,0x24,0x08,0x16,0xE9,0x11,0xB1,0x49,0xB4,0x14,0xE1,0x11,0x23
db 0x0A,0x15,0xEB,0x4A,0xB3,0x12,0xA6,0x12,0x2B,0x11,0x22,0xC0,0xEA,0x16,0x45,0x15
db 0xA5,0x11,0xA4,0x18,0x21,0x11,0x03,0x52,0x0D,0x1E,0xC7,0x62,0x06,0x90,0x10,0x71
db 0x00,0x50,0x10,0xF0


SECTION .bss

