comment |* Sniper
         * Forever Young Software
         * http://www.fontiernet.net/~fys/index.htm
         * fys@fontiernet.net
         *
         * ENTRY.COM (750 bytes)
         * NBASM 00.26.xx  (http://www.fontiernet.net/~fys/newbasic.htm)
         * 31 Oct 2008
         *
         * This code uses a bit stream created with parseit.c
         * See parseit.c for more information on what it does.
         *
         * The bit stream is as follows:
         * 
         *  0  regular 3-bit value (0 - 7)
         *  1   00 = new color change
         *         xxxx = 4 bit back/fore value (see color_data)
         *      01 = a count of DB's
         *         cccc     = count
         *      10 = a count of regular char
         *         cccc     = count
         *         xxxxxxxx = regular char
         *      11 = a count of spaces
         *         cccc     = count
         *
         * Therefore:
         *   regular char     =  4 bits
         *   new color change =  7 bits
         *   count of DB's    =  7 bits
         *   count of spaces  =  7 bits
         *   count of chars   = 15 bits
         *
         *
         *|


.model tiny
.code
.386
           org  100h

           mov  al,03
           int  10h

           push 0B800h
           pop  es
           mov  di,16

           mov  ah,06h  ; first 2 'tokens' are to make ah = 06h anyway.
           cwd

           mov  si,offset image_data
           mov  bx,offset color_data
      
main_loop: cmp  di,(80*2*21)
           jae  short Done

           call get_bits    ; get the next 8 bits in al
           js   short not_reg_char

           ; is regular char
           sub  dx,4        ; 'push' the last 4 bits back on the stream
           shr  al,4        ; we only wanted 4 bits (total)
           or   al,10110000b
           cmp  al,10110010b
           jbe  short blit_it
           xor  al,01101000b
blit_it:   inc  cx
           rep
           stosw
           jmp  short main_loop


not_reg_char:
           dec  dx             ; 'push' the last bit back on the stream
           mov  cl,al          ; we only wanted 7 bits
           shr  cl,1           ; shift it over to left byte aligned
           and  cl,0Fh         ; counts and color code is 4 bits

           test al,40h
           jnz  short count_chars

           test al,20h
           mov  al,0DBh
           jnz  short blit_it

           mov  al,cl
           xlatb
           mov  ah,al
           jmp  short main_loop

count_chars:
           and  al,20h         ; if bit 5 set, is spaces
           jnz  short blit_it

           push cx
           call get_bits       ; get 8 bit char
           pop  cx

           jmp short blit_it

Done:      ; it is smaller to make the last line here,
           ;  instead of the bit stream
           mov  ax,06DFh
           mov  cl,80
           rep
           stosw

           xor  ah,ah
           int  16h
           ret


; gets cx count of bits in al
; returns zero flag set if al = 0
get_bits   proc near
           mov  cl,8
           xor  al,al
@@:        shl  al,1
           bt   [si],dx            ; get bit
           inc  dx                 ; does not affect the carry flag
           adc  al,ch
           loop @b
           ret
get_bits   endp


color_data db 06h,07h,08h,0Eh,0Fh,60h,68h,6Fh,70h,76h,77h,78h,7Fh

image_data:
incbin bit_image.bin

.end


Notes:
1. I can get rid of one byte by doing
     bt image_data,dx
   but NBASM doesn't assemble it correctly.


2. I had a lot of time for a few days at the first of
   this compo and got down to about 760 or so.  Then
   all of a sudden, work got really busy and I no longer
   had any time to work on this.  However, I had lots of
   fun and appreciate all those who put any effort into
   helping this compo.

   Thanks to all.
   Ben

