;;;
;;;  Hugi Size Coding Competition 27 - ANSI Image
;;;
;;;  This is an almost-standard LZ77 decoder, with hand-tuned sort-of
;;;  huffman encoding. We're decompressing the character stream and the
;;;  color stream separately. All the compression intelligence lies in
;;;  the compressor program, compress.pas.
;;;
;;;  This passes tester2, but not tester, because the compressor uses the
;;;  rules' permission to exchange characters (lossy compression).
;;;
;;;  To build,
;;;      bpc compress.pas
;;;      compress > data.inc
;;;      tasm /m entry.asm
;;;      tlink /t entry.obj
;;;  or use the Makefile.
;;;
;;;  The 'bt' instruction rocks (although not using the 'bp' register as
;;;  'bit pointer' saved 2 bytes :-)
;;;
;;;  By Stefan <streu@gmx.de>
;;;
;;;  04/Oct/2008   1038 bytes: first version, with lossless compression
;;;  05/Oct/2008   932 bytes: lossy compression
;;;                853 bytes: optimized storage
;;;                843 bytes: optimized; use more assumptions from general.txt
;;;                838 bytes: optimized character replacement rules for sample image
;;;                810 bytes: separate format for frequent/infrequent literals
;;;                798 bytes: optimized character replacement rules even more
;;;                794 bytes: code optimisation
;;;  25/Oct/2008   774 bytes: use minimum length of backreferences
;;;                771 bytes: adjusted frequent literal table again
;;;                760 bytes: different frequent literal tables for colors and text
;;;                757 bytes: code optimisation
;;;  26/Oct/2008   753 bytes: code optimisation
;;;                753 bytes: clear screen, but omit blank characters at end
;;;  27/Oct/2008   752 bytes: adjusted frequent literal table :-)
;;;

        model   tiny
        codeseg
        org     100h
        p386

; Set to 1 to run this in Turbo Debugger
DEBUGGER = 0

start:
        mov     ax,3             ; clear screen and tell WinXP that we want to access the screen
        int     10h
        push    0B800h           ; set target address
        pop     es

if DEBUGGER
        xor     di,di
        mov     si,offset CharacterData
        xor     dx,dx            ; bit pointer
        xor     cx,cx            ; we assume ch remains 0 all the time
else
        scasw                    ; set di to 0, general.txt
        mov     dx,8*(offset CharacterData - offset start)  ; this assumes si=0100h, general.txt
endif
        mov     bx,offset FrequentLiteralTable

        ; cld                    ; not needed, general.txt

        jmp     Decompress
EndDecompress:
        ; xor     ax,ax          ; not needed, because AH=0 if Decompress ended with a backreference (which it does)
        int     16h
        ret

; ----------------------------------------------------------------------

BackReference:
        call    FetchVBits
        imul    bp,ax,-2
        call    FetchVBits
        add     al,3             ; length always fits in 8 bits, so no need to add to ax
        xchg    cx,ax
CopyLoop:
        mov     al,es:[bp+di]
Store:
        stosb

        ;; Have we reached the end?
        cmp     di,2*NUM_CHARACTERS-1
        ja      EndDecompress
        jne     ContinueDecompress
        xor     di,di
        mov     bl,offset FrequentColorTable - offset start

ContinueDecompress:
        inc     di
        loop    CopyLoop

;;; Decompressor entry:
;;;    ds:si -> input bitstream
;;;    dx    =  input bit pointer
;;;    es:di -> output area
Decompress:
        bt      word ptr [si],dx
        inc     dx
        jc      BackReference

IsLiteral:
        ; Start by fetching 9 bits. That's the frequent/infrequent bit,
        ; plus either the literal or table index plus 5 bits.
        mov     cl,9
        ; xor     ax,ax      ; not needed, FetchBits will overwrite all relevant bits
        call    FetchBits    ; yields 9th bit in CF
        jnc     InfrequentLiteral

        ; It's a frequent literal (from the table), so put back 5 bits.
        shr     al,5
        sub     dx,5
        xlat

InfrequentLiteral:
        inc     cx           ; tells Store to store once
        jmp     Store

; Fetch variable-length encoded value: starts with 3 bits length plus
; respective number of bits for value; for example, 17 (10001b) is
; stored as 100 0001 (4 value bits; MSB is implicitly 1).
FetchVBits:
        mov     cl,3
        xor     ax,ax
        call    FetchBits
        xchg    cx,ax
        inc     ax
        jcxz    NoBits

; Fetch bits.
;   In:  cx = bitcount, ax = initial value
;   Out: cx = 0,        al = bits, CF = 9th bit (if requested)
FetchBits:
        bt      word ptr [si],dx
        inc     dx
        adc     al,al
        loop    FetchBits
NoBits: ret

FrequentLiteralTable:
        db      32,101,176,177,178,219,220,223
FrequentColorTable:
        db      6,7,8,112,120,127,96

        include data.inc

        end     Start
