;
;
; Hugi size coding Compo 27 Entry
; -------------------------------
; 
; by Tapani Utriainen ( once known as: nadir/RAGE ... back in the golden age of demos )
;
; There is nothing really astonishing about this.
;
; * Characters and colours are RLE compressed separately in a first pass.
; * The resulting data and run lengths are Huffman compressed with 8-bit dictionaries.
; * RLE-data is not using an optimal Huffman tree, but instead it uses a suboptimal tree where
;   the leafs are ordered by their values, i.e the dictionary is 0,1,2,3,...,n
;   This has the benefit that the dictionary does not have to be stored at all.
;   Here, the difference was only like 9 bits cf optimal tree, and the gain much larger.
; * The resulting data chunks interleaves data and run lengths, so decompression is done
;   from the same chunk, but with alternating trees (i.e. same data array and counters apply).
;
; While I have some tools to generate the data files, I am sure others' are better. Half a dozen
; guys pwnd me hard after all. A few with over 100 bytes! (almost 150). How the heck?! 
; 
; My numbers:
; 	Data: 593 bytes
; 	Code: 111 bytes
; 	Misc: 10 bytes (variables used by decompressor)
;	--------------
;	Total: 714 bytes
;
; The code can be tuned smaller, however any large gains are in data compression. 
;
; Happy coding ^^
;
; //Tapani
;
;

.486	; an elegant weapon for a more civilized time

; displacement should be 724 - file size, some offsets are stored in MOD 256 when the high order byte is known
; (see the data chunks)

DISPLACEMENT EQU 10

cseg	segment use16
	assume	cs:cseg, ds:cseg, ss:cseg, es:cseg
	org	100h

; -------------------------------

start:	
	mov	ax, 0003h
	int	10h			; there is a byte to save here... left as an exercise to the reader
	
	push	0b800h
	pop	es
	xor	di, di

	lea	si, charblock
; di = dest
; si = block
decode:
	push	si
	xor	dx, dx
@decloop:
	pop	si
	push	si				; another one from the pushing/poping of si
	lodsw
	mov	bp, ax		; wtf?! no xchg? ^^
	xor	bx, bx
@hdl:
	lodsb					; ah, this is why -- so the high order byte stays untouched and the byte offset can be used

; ==============================
; Huffman decoder
; bp = data
; ax = tree
; dx == current position in data
; returns cx == word ix to decode, dx is increased by bit count
; ==============================
hufdecode:
	push	si
	xchg	ax, si
	xor	ax, ax		; set to tree node no
@readdatabit: 			; si = tree, bp = data
	xor	cx, cx		; counter used by right brancher and table lookup 
	xchg	ax, dx		; dx <- tree ix, ax = data ix
	xchg	bp, si		; bp <- tree, si <- data
	call	getbit		; same as isleaf
	xchg	ax, dx		; dx <- data ix, ax = tree ix
	xchg	bp, si		; bp <- data, si <- tree
	jnc	short @leftbranch ; a 0 bit means left, 1 means right

; increases ax to the right child branch, cx should start at 1
@branchnode:
	inc	cx
@nextnode:
	call  isleaf
	jnc	short @branchnode
	loop	short @nextnode
@leftbranch:
	inc	dx		; increase after getbit above wo destroying carry
	call	isleaf
	jnc	short @readdatabit

; count leafs until pos ax
; expects si = tree
@l1:
	call	getbit
	adc	cx, 0
	dec	ax
	jg		@l1
	xchg	ax, si	
	pop	si				; restore si to data block
; done decoding, answer in cx (>0)
;	mov	ax, bp		; to enable lodsb
	xchg	bx, cx
	jcxz	short @hdl

	lodsb
	xchg	ax, bx
	xlat
@l:
	stosb
	inc	di
	loop	short @l
	cmp	di, 0dbeh
	jle	short @decloop
	pop	bx			; to restore stack of all the si:s	
	dec	di
	and	di, 1
	jnz	short decode

	int	16h
clearscr:

; -------------------------------
; the ax:th bit of [si] determines the carry flag
; getbit destroys flags, isleaf incs ax
isleaf:
	inc	ax
getbit:
	pusha
	mov	cx, ax
	and	cl, 7
	shr	ax, 3
	inc	cx
	add	si, ax
	lodsb
	shl	al, cl
	popa
	ret

; ==============================

charblock	dw offset char_data
				db 8Ah - DISPLACEMENT, 83h - DISPLACEMENT, 8Fh - DISPLACEMENT
;				dw offset charrep_tree, offset char_tree, offset char_codes - 1
colblock		dw offset col_data
				db 0CCh - DISPLACEMENT, 42h - DISPLACEMENT, 44h - DISPLACEMENT
;				dw offset colrep_tree, offset col_tree, offset col_codes - 1

char_tree:
	db	01Ch,0A1h,06Bh,02Dh,069h,0ABh,060h
charrep_tree:
	; trees end with a set bit, so when only one bit is used here it can be overlapped
	db	052h,071h,066h,09Ch,05Ch,03Bh ; ,080h  
char_codes:
	db	0DCh,0B2h,020h,0B0h,0DFh,0FEh,077h,079h,073h,070h,074h,06Eh,06Ch,06Fh,048h,021h
	db	050h,0DDh,061h,0DEh,065h,063h,052h,069h,0B1h,0DBh
char_data:
	db	0E4h,0B7h,086h,01Dh,03Ch,03Fh,07Eh,096h,04Eh,0F4h,03Bh,0BCh,03Fh,07Eh,056h,041h
	db	0DBh,014h,0D5h,0E9h,0EAh,0D3h,0FDh,0BBh,01Eh,01Bh,011h,0C6h,0C3h,08Bh,026h,08Eh
	db	075h,041h,044h,02Eh,017h,0F8h,030h,094h,0B3h,0E0h,0A9h,0E1h,0D5h,016h,04Bh,014h
	db	06Dh,0ADh,0ABh,057h,02Fh,057h,09Ah,005h,033h,045h,0C7h,07Eh,015h,038h,04Ah,06Ah
	db	0B0h,0E6h,016h,0E1h,0A3h,07Ch,0B0h,0E6h,0BAh,030h,0BBh,038h,0F6h,0E0h,0A7h,028h
	db	0D2h,0C8h,0D1h,043h,06Eh,0AAh,079h,021h,0BEh,01Bh,051h,086h,0E3h,0DFh,0D7h,03Eh
	db	034h,062h,08Ch,0F4h,06Fh,0DDh,015h,0EBh,0D5h,07Ah,0AFh,0A2h,0BDh,046h,0F7h,0AEh
	db	079h,046h,0C5h,019h,0E8h,0DDh,095h,041h,0C3h,0B2h,0F0h,0BCh,034h,0F8h,0AFh,05Dh
	db	09Dh,060h,0BFh,097h,0CBh,025h,09Ch,0AFh,0F5h,0A4h,0ADh,0EBh,0E5h,0E2h,0FCh,0BEh
	db	058h,05Dh,073h,094h,0D5h,016h,016h,046h,0ECh,0A8h,035h,0F8h,034h,061h,0A7h,009h
	db	056h,0BEh,06Eh,03Eh,0F5h,0CFh,0C2h,024h,05Eh,0DDh,095h,062h,0AFh,0BFh,003h,057h
	db	0BDh,073h,0F0h,0B1h,017h,016h,0E8h,0ECh,062h,0AFh,09Eh,02Ch,0F8h,014h,0EAh,00Ah
	db	080h,0ABh,097h,05Ch,0FCh,02Ch,02Eh,045h,0B8h,042h,0EBh,065h,0E5h,066h,058h,0F3h
	db	086h,03Eh,0F1h,064h,0B9h,046h,0C1h,046h,005h,007h,01Dh,073h,0F0h,0B8h,0BAh,047h
	db	06Dh,0D6h,0CBh,0CAh,0D4h,0B5h,0ACh,055h,0F2h,0D1h,06Eh,0BEh,02Ah,0F3h,0E2h,0C8h
	db	0E8h,0F9h,01Ah,08Dh,050h,071h,0D7h,03Eh,0D8h,094h,067h,01Dh,0B7h,06Bh,0C5h,0C6h
	db	0E2h,0E3h,0ABh,055h,09Ch,07Ah,0F1h,064h,0BEh,04Ah,08Eh,00Eh,07Dh,073h,0EDh,076h
	db	042h,0CEh,03Bh,05Ch,052h,02Ch,02Eh,0C2h,0E2h,0E3h,0A2h,017h,039h,0D4h,0DDh,038h
	db	0B2h,05Dh,047h,0BFh,0AEh,07Dh,0A2h,05Eh,0CEh,0DBh,045h,091h,086h,0C2h,091h,067h
	db	06Dh,011h,071h,060h,055h,0DBh,09Fh,016h,075h,060h,0F1h,0D7h,03Eh,0A8h,0B9h,062h
	db	082h,0DBh,047h,023h,025h,093h,030h,0B6h,08Bh,00Bh,024h,041h,04Dh,0D3h,08Bh,026h
	db	003h,0A5h,075h,0EBh,09Fh,044h,05Ch,08Eh,041h,0A6h,0ABh,021h,0D6h,014h,064h,064h
	db	0D1h,046h,043h,0A6h,035h,072h,0ECh,086h,0F3h,091h,080h,0EEh,0B3h,0AEh,07Ch,063h
	db	02Dh,042h,02Dh,04Dh,014h,09Ch,085h,00Dh,00Dh,034h,069h,02Dh,093h,06Eh,0EBh,04Fh
	db	0ACh,07Ah,05Bh,03Eh,009h,051h,004h,065h,092h,0FCh,08Ch,03Ah,00Ch,098h,03Bh,0AFh
	db	0D0h,0ABh,0E4h,07Fh,05Fh,0D7h,0F5h,0BAh

col_tree:
	db	021h,0AFh,04Eh
col_codes:
	db	006h,06Fh,070h,076h,060h,068h,00Eh,078h,008h,07Fh,00Fh,007h
col_data:
	db	0D2h,075h,0E7h,05Eh,0BBh,03Ah,0B3h,0F5h,051h,0D4h,0FAh,09Dh,056h,01Ah,0D4h,03Bh
	db	0DAh,0F7h,033h,041h,087h,0A6h,077h,033h,06Eh,0D2h,0E5h,0BBh,076h,076h,01Bh,0D3h
	db	070h,08Ah,05Ah,00Dh,0EDh,0DBh,014h,0CFh,0BAh,0E8h,018h,0B3h,047h,00Fh,094h,01Ch
	db	061h,0F3h,09Bh,00Ah,045h,05Ah,0BEh,00Fh,026h,05Ch,098h,0F9h,04Dh,003h,032h,054h
	db	0ABh,04Bh,003h,083h,00Eh,0B3h,01Fh,013h,065h,043h,0B3h,0C1h,0E4h,0CBh,0D9h,036h
	db	05Eh,02Eh,0FCh,03Fh,093h,066h,045h,0DAh,0C1h,0FAh,093h,08Dh,030h,077h,061h,0FBh
	db	067h,09Ah,0A9h,096h,096h,00Fh,053h,01Eh,0EAh,00Fh,026h,0A7h,046h,01Ch,0DAh,0FCh
	db	062h,005h,037h,026h,00Ah,075h,010h,090h,021h,0CEh,040h
colrep_tree:
	db	00Dh,095h,08Bh,06Ch,05Ah,072h,032h,0BEh

	cseg	ends
	end	start

