
#include <stdio.h>
#include <math.h>


  int buf[256];
  int ac[256];
  int tot = 0;
  float totbits = 0;
  int fsee[256];

void hist(char* filename) {
  FILE* file = fopen(filename, "rb");
  int c1,c2;
  int c;
  int n = 0;
  float nbits;
  int cur = 0;
  int lastcur = 0;
  int i;
  int cmax = 0;

  if(!file) return;

    // hist

  memset(buf, 0, sizeof(buf));
  memset(fsee, 0, sizeof(fsee));
  while(1) {
    c1 = fgetc(file);
    if(c1 < 0) break;
    c = c1;
    if(!buf[c]) { printf("new symbol %04x @ offset %5d\n", c, n); n = 0; fsee[c] = cur; }
    if(c > cmax) cmax = c;
    else n++;
    buf[c]++;
    cur++;
  }
  fclose(file);
  printf("\n");

  n = 0;
  for(c=0;c<256;c++) {
//    if(buf[c] <= 2) buf[c] = 0;
  }

  n = 0;
  for(c=0;c<256;c++) {
    if(buf[c]) { printf("| %04X :%5d ", c, buf[c]); n++; }
    if(n==8) { printf("|\n"); n = 0; }
  }
  printf("\n\n");





    // ac

  memset(ac, 0, sizeof(ac));
  for(c=1;c<256;c++) {
    ac[c] = ac[c-1] + buf[c-1];
  }
  tot = ac[c-1];

  printf("num symbols = %d\n\n", tot);

  n = 0;
  for(c=0;c<256;c++) {
    if(buf[c]) { printf("| %04X :%5.2f ", c, log(1.0 * tot / (ac[c+1] - ac[c])) / log(2) ); n++; }
    if(n==8) { printf("|\n"); n = 0; }
  }
  printf("\n\n");

#if 0
  n = 0;
  for(c=0;c<256;c++) {
    if(buf[c]) {
//      nbits = buf[c] * (log(1.0 * tot / (ac[c+1] - ac[c])) / log(2));
      nbits = buf[c] * (log(1.0 * tot / (buf[c])) / log(2));
      printf("| %04X :%6.2f ", c, nbits ); n++;
      totbits += nbits;
    }
    if(n==8) { printf("|\n"); n = 0; }
  }
#endif

  cur = 0;
  file = fopen(filename, "rb");
  while(1) {
    c1 = fgetc(file);
    if(c1 < 0) break;
    c = c1;
    tot = 0;
    for(i=0;i<cmax;i++) if(cur >= fsee[i]) tot += buf[i];

      nbits = (log(1.0 * tot / (buf[c])) / log(2));
//printf("%5d : [%02d] = %d / %d  bits=%.2f\n", cur, c, buf[c], tot, nbits);
    totbits += nbits;
//    tot--;
    buf[c]--;
    cur++;
  }
  fclose(file);

  printf("\n\ntotal bits = %5.2f = %5.2f bytes\n\n", totbits, totbits/8);


}


int main(int argc, char** argv) {
  int i;

  for(i=1;i<argc;i++) {
    hist(argv[i]);
  }

  return 0;
}