
#include <stdio.h>
#include <math.h>


  int buf[256][256];
  int ac[256];
  int tot = 0;
  float totbits = 0;

  unsigned __int64 range_high = 0xffffffff;
  unsigned __int64 range_low = 0x00000000;
  unsigned __int64 range_len;

void hist(char* filename) {
  FILE* file = fopen(filename, "rb");
  int c1,c2;
  int c;
  int lastc;
  int n = 0;
  float nbits;
  int cur = 0;
  int lastcur = 0;
  int i,j;
  int cmax = 0;
  unsigned char byteout;
  FILE* outad1 = fopen("out.ad1", "wb");
  int highest = 0;
  int highestr = 0;

  if(!file) return;

    // hist

  memset(buf, 0, sizeof(buf));
  while(1) {
    c1 = fgetc(file);
    if(c1 < 0) break;
    c = c1;
    if(c > cmax) cmax = c;
  }
  fclose(file);
  printf("\n");


#define w 20

  for(j=0;j<=cmax;j++) {
    for(i=0;i<=cmax;i++) buf[j][i] = 1;
  }
//    buf[0][0] = 5888;

  lastc = cur = 0;
  file = fopen(filename, "rb");
  while(1) {
    c1 = fgetc(file);
    if(c1 < 0) break;

    memset(ac, 0, sizeof(ac));
    for(c=1;c<256;c++) {
      ac[c] = ac[c-1] + buf[lastc][c-1];
    }
    tot = ac[c-1];

    if(tot > highestr) { highestr = tot; printf("new highr = %d\n", highestr); }

    c = c1;

    range_len = (range_high - range_low);
//printf("%d %d %08x %08x %08x\n", ac[c], ac[c+1], (int)range_len, (int)range_low, (int)range_high);
    range_high = range_low + range_len * ac[c+1] / tot - 1;
    range_low += range_len * ac[c] / tot;
//printf("%08x %08x\n", (int)(range_len * ac[c] / tot), (int)(range_len * ac[c+1] / tot));

      nbits = (log(1.0 * tot / (buf[lastc][c])) / log(2));
//printf("%5d : [%02d][%02d] = %d / %d  bits=%.2f\n", cur, lastc, c, buf[lastc][c], tot, nbits);
    totbits += nbits;


//printf("--> %08x %08x\n\n", (int)range_low, (int)range_high);
    while( (range_high & 0xff000000) == (range_low & 0xff000000) ) {
      byteout = (range_low >> 24) & 0xff;
      fwrite(&byteout, 1, 1, outad1);
      range_len = range_high - range_low;
      range_low = (range_low << 8) & 0xffffff00;
//      range_high = (range_high << 8) & 0xffffff00;
      range_high = range_low + range_len * 256 - 1;
//printf("%02x\n", byteout);
//printf("--> %08x %08x\n\n", (int)range_low, (int)range_high);
    }

//    tot--;
if(c)    buf[lastc][c] += w;
else    buf[lastc][c] += w;
if(buf[lastc][c] > highest) { highest = buf[lastc][c]; printf("new high: %d\n", highest); }
    cur++;
    lastc = c;
//    if(lastc) lastc = 1;
  }
  fclose(file);

  for(i=0;i<4;i++) {
    byteout = (range_low >> 24) & 0xff;
    fwrite(&byteout, 1, 1, outad1);
    range_low >>= 8;
  }


  printf("\n\ntotal bits = %5.2f = %5.2f bytes\n\n", totbits, totbits/8);


}


int main(int argc, char** argv) {
  int i;

  for(i=1;i<argc;i++) {
    hist(argv[i]);
  }

  return 0;
}
