
#include <stdio.h>
#include <math.h>


  int buf[256][256][256];
  int ac[256];
  int tot = 0;
  float totbits = 0;

void hist(char* filename) {
  FILE* file = fopen(filename, "rb");
  int c1,c2;
  int c;
  int lastc;
  int lastlastc;
  int n = 0;
  float nbits;
  int cur = 0;
  int lastcur = 0;
  int i,j,k;
  int cmax = 0;

  if(!file) return;

    // hist

  memset(buf, 0, sizeof(buf));
  while(1) {
    c1 = fgetc(file);
    if(c1 < 0) break;
    c = c1;
    if(c > cmax) cmax = c;
  }
  fclose(file);
  printf("\n");


#define w 20

  for(k=0;k<=cmax;k++) {
    for(j=0;j<=cmax;j++) {
      for(i=0;i<=cmax;i++) buf[k][j][i] = 1;
    }
  }
//    buf[0][0] = 5888;

  lastlastc = lastc = cur = 0;
  file = fopen(filename, "rb");
  while(1) {
    c1 = fgetc(file);
    if(c1 < 0) break;

    memset(ac, 0, sizeof(ac));
    for(c=1;c<256;c++) {
      ac[c] = ac[c-1] + buf[lastlastc][lastc][c-1];
    }
    tot = ac[c-1];

    c = c1;


      nbits = (log(1.0 * tot / (buf[lastlastc][lastc][c])) / log(2));
printf("%5d : [%02d][%02d][%02d] = %d / %d  bits=%.2f\n", cur, lastlastc, lastc, c, buf[lastlastc][lastc][c], tot, nbits);
    totbits += nbits;
//    tot--;
if(c)    buf[lastlastc][lastc][c] += w;
else    buf[lastlastc][lastc][c] += w;
    cur++;
    lastlastc = lastc;
    lastc = c;
//    if(lastc) lastc = 1;
  }
  fclose(file);

  printf("\n\ntotal bits = %5.2f = %5.2f bytes\n\n", totbits, totbits/8);


}


int main(int argc, char** argv) {
  int i;

  for(i=1;i<argc;i++) {
    hist(argv[i]);
  }

  return 0;
}