	page	240, 132
;Entry.asm		31-Oct-2009	Boreal		loren.blaney@idcomm.com
;A Spooky Maze Generator for Hugi Compo 29
;Assemble with:
; tasm
; tlink /t

Cols	equ 25			;dimensions of maze (cells)
Rows	equ 10

	.model	tiny
	.code
	.486
	org	100h
;ax=0, bx=0, cx=00FFh, dx=cs, si=0100, di=-2, bp=09xx, sp=-2
start:
; Set seed with decimal integer on command line.
; Range 0..100. Use 0 if no number is entered.
;(ax=0)

if 0				;initialize registers for debugger
	mov	cx, 00FFh
	mov	dx, cs
	mov	si, 0100h
	mov	di, -2
	mov	bp, 0955h
endif
	mov	si, 5Dh		;point to info from command line
ni10:	aad			;al:= ah*10 + al; ah:= 0
	xchg	dx, ax		;(thanks to Aphex's "distribution of bytes")
	mov	ah, dl		;ah = accumulator
	lodsb			;get char from command line; al:= ds:[si++]
	sub	al, '0'		;convert ASCII to binary
	jge	ni10		;loop until not a digit (0..9)
	xchg	[si], dx	;set random number seed, and dx:= two spaces!

	mov	al, '$'		;fill locations starting at 09xxh with '$'
	mov	cx, bp		; string terminators
	mov	di, bp		;also forms top and bottom borders of maze
	rep stosb		;es:[di++]:= al; cx--

;Randomly pick a starting cell in the maze
;ConnectFrom(Ran(Cols), Ran(Rows))
RowLen	equ	Cols*3+3	;number of chars in a (half) Row +--+...+--+CrLf
;bx = Maze + 3*Col + 2*Row*RowLen + RowLen + 1
	call	Random
	aam	Cols		;al:= rem(al/Cols); ah:= al/Cols
	cbw			;ah:= 0
	imul	bx, ax, 3	;bx = partial result for starting cell
	lea	di, [bp+si]	;start maze at least one row after the '$$$$$$$'
	lea	bx, [bx+di+RowLen+1] ;add start of maze and offset to first cell

	call	Random		;finish calculation for address of starting cell
	aam	Rows		;al:= rem(al/Rows)
	mov	ah, RowLen*2
	mul	ah		;ax:= al*ah
	add	bx, ax		;bx = address of starting cell

	mov	ax, '-|'	;fill string with all walls and all ceilings
	mov	cl, Rows*2+1
ma05:	xor	al, 57h		;flip between '+' and '|'
	mov	ch, Cols+1
ma10:	stosw			;+--+--+-- ... +--+ cr lf
	mov	[di], ah	;|--|--|-- ... |--| cr lf
	inc	di		;+--+--+-- ... +--+ cr lf
	dec	ch		;loop for next column
	jne	ma10
	mov	word ptr [di-2], 0A0Dh	;overwrite Cols+1 with cr lf
	loop	ma05		;loop for next row

	or	[di-RowLen-3], al ;place house, 7F = 7C | 2B

;Connect cells starting from cell located at address in bx register
;(di is at the end of the maze, so the maze is not altered the first time
; this next instruction is executed)
con05:	mov	[bx+di], dx	;knock down wall or ceiling with spaces
	mov	[bx], dx	;connect cell at [bx] by writing spaces

	call	Random		;randomly choose a direction
	xchg	di, ax		;set up direction index in di
;(ch=0)
	mov	cl, 4		;for right, down, left, up do ...
con10:	mov	ax, 3		;mask index to limit its range to 0..3
	and	di, ax
	pusha			;save ax, bx, cx, di
	imul	byte ptr [Tbl+di] ;ax:= al*<src>; convert byte *3 to word
				;ax = offset to adjacent cell
	sub	bx, ax		;set bx to possible new cell location

	sar	ax, 1		;calculate offset to knock down either a wall
	xchg	di, ax		; or ceiling using space characters

	cmp	byte ptr [bx], '-' ;there must be a minus sign at this location
	je	con05		;loop if so; else cell is connected or location
;(carry set)			; is at a border (2D vs: 20, 24, 0A, all lower)
con20:	popa			;restore ax, bx, cx, di

	inc	di		;try next direction
	loop	con10
;(ax=3, carry set)
	adc	ax, sp		;backtrack: loop until all directions have been
	js	con20		; tried with the starting cell
;(ax=2, sp=-2)
	mov	[si+bp+RowLen], al ;place ghost, 02

	lea	dx, [bp+si]	;display the '$'-terminated string at ds:dx
	xchg	ax, bp		;ah:= 09h
	int	21h
;	ret

;-------------------------------------------------------------------------------
;Generate a random number in al using the "multiplicative congruential" method
; Seed:= Seed*4E35h + 1
;
Random:	imul	ax, [si], 4E35h
	inc	ax
	mov	[si], ax	;save seed
	mov	al, ah		;return its high byte
	ret

Tbl	db	-3/3, -RowLen*2/3, 3/3, RowLen*2/3 ;offset to move between cells
	end	start
