; Maze Generator for Hugi Compo #29
; by brox/THIRTEEN
;
; tasm /m9 entry.asm
; tlink /t/x entry.obj
Cols            equ     25
Rows            equ     10

.model tiny
.486

_AAD            MACRO   BASE
                db      0D5h, BASE
ENDM

_AAM            MACRO   BASE
                db      0D4h, BASE
ENDM

.code
                org     100h
start:
                db      -1, -(Cols+1)*2-1       ;2; dec bx ; 2 bytes :)
                db      1, (Cols+1)*2           ;2; add [si],si
                                                  ; = 4
; Read decimal integer random seed from the command line and return it in dx register
; Returns 0 if no command line args
get_num:
                _AAD    10                      ;2; al = ah * 10 + al; ah = 0
                xchg    ax, dx                  ;1; Seed
                mov     ah, dl                  ;2; ah = 0..100
                mov     al, [bx + 5Eh]          ;3; next digit
                inc     bx                      ;1;
                sub		al, '0'                 ;2;
                jge     get_num                 ;2;
                                                  ; = 13
; ah = 0..64h, al = 0F0h, cx = 0FFh, bx = 0..3
; init cells array
                mov     di, bp                  ;2;
                rep     stosb                   ;2; 255 times 0F0h
                push    di                      ;1; start of the maze
                mov     bl, (Rows+1)*2-1        ;2;
                mov     ax, '-+'                ;3;
v1:             mov     cl, Cols                ;2;
h1:             stosw                           ;1;
                mov     [di], ah                ;2;
                inc     di                      ;1;
                loop    h1                      ;2;
                stosb                           ;1;
                xor     al, '+' XOR '|'         ;2;
                mov     word ptr [di], 0A0Dh    ;4;
                scasw                           ;1;
                dec     bx                      ;1;
                jnz     v1                      ;2;
                xchg    ax, cx                  ;1; cx = '-|' = 2D7Ch
                mov     al, '$'                 ;2;
                mov     byte ptr [di-(Cols+1)*3-3], 7Fh  ;4;
                rep     stosb                   ;2;
                sub     di, 3394h               ;4;
                mov     al, 2                   ;2;
                stosb                           ;1;
                                                  ; = 46

;Randomly pick starting cell
                mov     bl, 3                   ;2;
twice:          call    Rnd
smc:            _AAM    Cols                    ;2; ah = al/Cols; al = al mod Cols
                mul     bl                      ;2; _AAD X ; al = ah * X + al; ah = 0
                add     di, ax                  ;2;
                mov     byte ptr [si+offset smc-offset start+1], Rows ;4;
                xor     bl, 3 XOR (Cols+1)*6    ;3;
                js      twice                   ;2;
                call    ConFrom                 ;3;
                                                  ; = 23
; Display the maze
                pop     dx                      ;1;
                xchg    ax, bp                  ;1;
                int     21h                     ;2;
                                                  ; = 4
; Random number generator
Rnd:            imul    dx, 4E35h               ;4;
                inc     dx                      ;1;
                mov     al, dh                  ;2;
                ret                             ;1;
                                                  ; = 8
; Connect cells starting from cell @di
ConFrom:        call    Rnd
dir_loop:       push    ax di                   ;2;
                
                and     al, 3                   ;2; next Dir (0000, 0001, 0010, 0011)
                mov     bx, si                  ;2; offset start
                xlatb                           ;1; (11111101, 01100100, 00000011, 10011100)
                cbw                             ;1;
                imul    bx, ax, 3               ;3; next cell offset (0FFFDh, 0FF64h, 0003h, 009Ch)

                mov     ax, '  '                ;3;
                mov     [di], ax                ;2; Mark current cell as connected
                sub     di, bx                  ;2;
                cmp     byte ptr [di], '-'      ;3; is connectable?
                jne     skip                    ;2;
                sar     bx, 1                   ;2; wall offset relative to next cell
                mov     [di + bx], ax           ;2; wipe the wall
                call    ConFrom                 ;3; continue recursively
skip:           pop     di ax                   ;2;
                inc     ax                      ;1;
                jns     dir_loop                ;2; loop 32768 times
                ret                             ;1;
                                                  ; = 39

                end     start
