	page	240, 132
;Example.asm		8-Sep-2009	Boreal		loren.blaney@idcomm.com
;A Spooky Maze Generator for Hugi Compo #29
;Assemble with:
; tasm
; tlink /t

Cols	equ 25			;dimensions of maze (cells)
Rows	equ 10

LeftWall  equ 0			;attributes of each cell
Ceiling   equ 1			;booleans: the cell has a wall on its left side,
Connected equ 2			; has a ceiling, or is connected to other cells

	.model	tiny
	.code
	.486
	org	100h
start:	call	NumIn		;get starting seed from the command line
	mov	word ptr Seed, ax

;Start with all walls and ceilings all in place and all cells disconnected

	mov	dx, 0		;for Y:= 0, Rows-1 do
ma10:	mov	cx, 0		; for X:= 0, Cols-1 do

ma20:	mov	bx, LeftWall*Cols*Rows	;Cell(X, Y, LeftWall):= true
	imul	si, dx, Cols
	add	bx, cx
	mov	[Cell+bx+si], 1

	mov	bx, Ceiling*Cols*Rows	;Cell(X, Y, Ceiling):= true
	imul	si, dx, Cols
	add	bx, cx
	mov	[Cell+bx+si], 1

	mov	bx, Connected*Cols*Rows	;Cell(X, Y, Connected):= false
	imul	si, dx, Cols
	add	bx, cx
	mov	[Cell+bx+si], 0

	inc	cx		;next X
	cmp	cx, Cols-1
	jle	ma20
	inc	dx		;next Y
	cmp	dx, Rows-1
	jle	ma10

;Randomly pick a starting cell

	mov	ax, Cols	;ConnectFrom(Ran(Cols), Ran(Rows))
	call	Ran
	mov	cx, ax
	mov	ax, Rows
	call	Ran
	mov	dx, ax
	call	ConFrom

;Display the maze

	mov	dx, 0		;for Y:= 0, Rows-1 do
ma50:	mov	cx, 0		; for X:= 0, Cols-1 do
;Print(if Cell(X, Y, Ceiling)  then "+--" else "+  ")
ma60:	mov	ax, Ceiling
	call	ChkCell
	je	ma65
	mov	si, offset Str1	;"+--"
	jmp	ma69
ma65:	mov	si, offset Str2	;"+  "
ma69:	call	Print

	inc	cx		;next X
	cmp	cx, Cols-1
	jle	ma60

	mov	al, '+'
	call	ConOut
	call	CrLf

	mov	al, 02h		;ConOut(if Y=0 then ghost else wall)
	cmp	dx, 0
	je	ma69a
	 mov	al, '|'
ma69a:	call	ConOut

	mov	al, 20h		;output two space characters
	call	ConOut
	mov	al, 20h
	call	ConOut

	mov	cx, 1		; for X:= 1, Cols-1 do
;Print(if Cell(X, Y, LeftWall) then "|  " else "   ")
ma70:	mov	ax, LeftWall
	call	ChkCell
	je	ma75
	mov	si, offset Str3	;"|  "
	jmp	ma79
ma75:	mov	si, offset Str4	;"   "
ma79:	call	Print

	inc	cx		;next X
	cmp	cx, Cols-1
	jle	ma70

	mov	al, '|'		;ConOut(if Y=Rows-1 then house else wall)
	cmp	dx, Rows-1
	 jne	ma80
	mov	al, 7Fh
ma80:	call	ConOut
	call	CrLf

	inc	dx		;next Y
	cmp	dx, Rows-1
	jle	ma50

	mov	cx, 0		;for X:= 0, Cols-1 do Print("+--")
ma90:	mov	si, offset Str1	;"+--"
	call	Print		;(when is a ceiling actually a floor?)
	inc	cx		;next X
	cmp	cx, Cols-1
	jle	ma90

	mov	al, '+'
	call	ConOut
	call	CrLf
	ret


Seed	dw	0		;seed for random number generator

Cell	db	Cols*Rows*3 dup(?)	;array of cells describing the maze

Str1	db	"+--", 0	;ceiling
Str2	db	"+  ", 0	;no ceiling
Str3	db	"|  ", 0	;left wall
Str4	db	"   ", 0	;no wall

;-------------------------------------------------------------------------------
;Routine to read a decimal integer from the command line and return it in ax
; Range 0..255
; Returns 0 if there is no number entered on the command line
;
NumIn:	push	dx		;preserve registers
	push	si

	mov	si, 81h		;point to info on command line
	xor	dx, dx		;zero accumulator

ni10:	mov	al, es:[si]	;fetch character from command line
	inc	si
	cmp	al, 0Dh		;carriage return?
	je	ni30		;exit if so
	sub	al, '0'		;is it a digit?
	jl	ni10		;loop if not
	cmp	al, 9
	jg	ni10
	mov	dl, al		;put first char into accumulator

ni20:	mov	al, es:[si]	;accumulate digits in dx until non-digit
	inc	si
	sub	al, '0'		;is character a digit?
	jl	ni30		;exit if not
	cmp	al, 9
	jg	ni30
	imul	dx, 10		;accumulate decimal integer
	cbw			;ah:= 0
	add	dx, ax
	jmp	ni20		;loop until non-digit is found
ni30:
	xchg	ax, dx		;return with integer in ax
	pop	si		;restore registers
	pop	dx
	ret

;-------------------------------------------------------------------------------
;Connect cells starting from cell X=cx, Y=dx
;
ConFrom:push	cx		;save variables
	push	dx
	push	Dir
	push	Dir0

;Mark current cell as connected

	mov	bx, Connected*Cols*Rows	;Cell(X, Y, Connected):= true
	imul	si, dx, Cols
	add	bx, cx
	mov	[Cell+bx+si], 1

	mov	ax, 4		;randomly choose a direction
	call	Ran
	mov	Dir, ax
	mov	Dir0, ax	;save this initial direction

;Try to connect to a cell at direction Dir

con10:	mov	ax, Dir		;repeat	case Dir of

;0: if X+1<Cols & not Cell(X+1, Y, Connected) then go right
;   [Cell(X+1, Y, LeftWall):= false; ConnectFrom(X+1, Y)]
	cmp	ax, 0
	jne	con20

	inc	cx		;X+1
	cmp	cx, Cols
	jge	con19

	mov	ax, Connected
	call	ChkCell
	jne	con19		;jump if right cell is already connected

	mov	bx, LeftWall*Cols*Rows
	imul	si, dx, Cols	;knock down new cell's left-side wall
	add	bx, cx
	mov	[Cell+bx+si], 0

	call	ConFrom		;connect rest of cells starting from here
con19:	dec	cx		;cx = X
	jmp	con90
con20:
;1: if Y+1<Rows & not Cell(X, Y+1, Connected) then go down
;   [Cell(X, Y+1, Ceiling):= false;  ConnectFrom(X, Y+1)]
	cmp	ax, 1
	jne	con30

	inc	dx		;Y+1
	cmp	dx, Rows
	jge	con29

	mov	ax, Connected
	call	ChkCell
	jne	con29

	mov	bx, Ceiling*Cols*Rows
	imul	si, dx, Cols	;knock down new cell's ceiling
	add	bx, cx
	mov	[Cell+bx+si], 0

	call	ConFrom
con29:	dec	dx		;dx = Y
	jmp	con90
con30:
;2: if X-1>=0 & not Cell(X-1, Y, Connected) then go left
;   [Cell(X, Y, LeftWall):= false;   ConnectFrom(X-1, Y)]
	cmp	ax, 2
	jne	con40

	dec	cx		;X-1
	cmp	cx, 0
	jl	con39

	mov	ax, Connected
	call	ChkCell
	jne	con39

	mov	bx, LeftWall*Cols*Rows
	imul	si, dx, Cols
	inc	cx		;cx = X
	add	bx, cx
	mov	[Cell+bx+si], 0

	dec	cx		;X-1
	call	ConFrom
con39:	inc	cx		;cx = X
	jmp	con90
con40:
;3: if Y-1>=0 & not Cell(X, Y-1, Connected) then go up
;   [Cell(X, Y, Ceiling):= false;    ConnectFrom(X, Y-1)]
	cmp	ax, 3
	jne	con90

	dec	dx		;Y-1
	cmp	dx, 0
	jl	con49

	mov	ax, Connected
	call	ChkCell
	jne	con49

	mov	bx, Ceiling*Cols*Rows
	inc	dx		;dx = Y
	imul	si, dx, Cols
	add	bx, cx
	mov	[Cell+bx+si], 0

	dec	dx		;Y-1
	call	ConFrom
con49:	inc	dx		;dx = Y
con90:

;Next direction

	mov	ax, Dir		;next Dir
	inc	ax		;Dir:= Dir+1 & $03
	and	ax, 3h
	mov	Dir, ax

	cmp	ax, Dir0	;loop until Dir = Dir0
	jne	con10

	pop	Dir0		;restore variables
	pop	Dir
	pop	dx
	pop	cx
	ret


Dir	dw	0		;direction: right, down, left, up
Dir0	dw	0		;copy of Dir

;-------------------------------------------------------------------------------
;Return processor status based on the contents of Cell(X=cx, Y=dx, Z=ax)
;
ChkCell:push	bx		;preserve registers
	push	si

	imul	bx, ax, Cols*Rows
	imul	si, dx, Cols
	add	bx, cx
	test	[Cell+bx+si], 0FFh

	pop	si		;restore registers
	pop	bx
	ret

;-------------------------------------------------------------------------------
;Return random number between 0 and ax-1
; return remainder(Random/N)
;
Ran:	push	cx		;preserve registers
	push	dx

	mov	cx, ax
	call	Random
	xor	dx, dx
	idiv	cx
	mov	ax, dx		;return remainder in ax

	pop	dx		;restore registers
	pop	cx
	ret

;-------------------------------------------------------------------------------
;Generate a random number in al using the "multiplicative congruential" method
;
Random:	push	dx		;preserve register

	mov	dx, Seed	;Seed:= Seed * Multiplier + 1
	mov	ax, 4E35h
	imul	dx
	inc	ax
	mov	Seed, ax	;Random number = Seed >> 8
	shr	ax, 8

	pop	dx		;restore register
	ret

;-------------------------------------------------------------------------------
;Print a carriage return followed by a line feed
;
CrLf:	mov	al, 0Dh		;carriage return
	call	ConOut
	mov	al, 0Ah		;line feed
	call	ConOut
	ret

;-------------------------------------------------------------------------------
;Print the string pointed to by the si register (which gets altered)
;
pr10:	call	ConOut
Print:	lodsb			;al:= ds:[si++]
	cmp	al, 0
	jne	pr10
	ret

;-------------------------------------------------------------------------------
;Display the character in al on the console (using a method that can be
; redirected to a file)
;
ConOut:	push	ax		;preserve registers
	push	dx

	mov	dl, al		;get character
	mov	ah, 02h		;set function for character output
	int	21h		;DOS call

	pop	dx
	pop	ax		;restore registers
	ret

	end	start
