        
        ; Hugi Size Coding Competition - Compo29 - Random Maze Builder
        ;
        ; Entry by Flyke ( ville@heaven.dk )
        ; 
        ; Last changed 31.10.09
        ;
        ;
        ; masm 6.14
        ; ml /c entry.asm
        ; link /tiny entry.obj,entry.com, , , ,

		Cols			equ 25			;dimensions of maze (cells)
		Rows			equ 10

		
        .model tiny
        .386
        .code
		
		org 100h
start:

	; assumptions
	;
	;	ax = bx = 0
	;	cx = FFh
	; 	assume command line is available at 05Dh. If nothing was entered it is assumed that the character at 05Dh is < '0'
	mov		si, 5Dh
			
ProcInput:
	imul	bx, 0Ah
	add  	bx,	ax         ; and add the old value of eax
			
	lodsb                	; get number from command line
	sub  	al,30h          ; if <'0' return negative number
	jns  	short ProcInput
inputdone:

	; bx holds our seed
	mov		dx, bx

	
; '+' == 02Bh
; '-' == 02Dh
; ' ' == 020h
; '|' == 07Ch
	
	
;initialize

	mov		di, 031Bh
	; cx = 0FFh
initloop:
	mov		al, '+'
	stosb
	mov		al, '-'
	stosb
	stosb
	loop	initloop

	dec		di
	dec		di
	mov		ax, 0A0Dh
	stosw
	
	push	di
	
	mov		cl, 76
	mov		al, '|'
	rep		stosb
	
	;mov		ax, 0A0Dh
	; ah=0Ah from last crlf
	mov		al, 0Dh
	stosw
	
	mov		cx, 2*741;(2*78*9,5) 2*741=1482=5CA
	; this value is the start of the maze when printing, save it
	push	cx
	
	mov		si, cx
	rep		movsb
	
	; ax = 0A0Dh
	xchg	ax, cx
	;mov		cx, 200
	;mov		ch, 2
	mov		al, '$'
	rep		stosb

	
;Randomly pick a starting cell

	call	Ran
	db		0D4h, Cols		; aam, Cols
	
	imul	ax, 3
	; ch = 0
	mov		cl, al
	
	
	call	Ran
	db		0D4h, Rows;		; aam, Rows - same as aam
	mov		ah, 0
	imul	di, ax, (Cols+1)*3*2
	add		di, cx
	
	add		di, 031Bh+151+(Cols+1)*3+179*3
	
	
	call	ConFrom

;Display the maze

plotmaze:

	
	
	; put house
	mov		al, 7Fh
	mov		[cs:(031Bh+150+(Cols*3+3)*Rows*2+Cols*3+3-Cols*3-6+179*3)], al
	

	
	pop		dx
	
	pop		di
	; put ghost
	;mov		al, 02h
	mov		ax, 0902h
	stosb
	
	
	;mov		ah, 09h
	;xchg	ax, bp
	int		21h
	
exit:
	ret


		
;-------------------------------------------------------------------------------
;Connect cells starting from cell X=cx, si = pos (X+Cols*Y)
; 
;
ConFrom:
	push	ax

;Mark current cell as connected

	mov		word ptr [di], 2020h
	
	call	Ran
	db		0D4h, 04h		; aam 04h

; 0 = right	(+3)
; 1 = down 	(+156)
; 2 = left  (-3)
; 3 = up  	(-156)

	; loop through all 4 directions
	mov		cl, 4

con10:	
	

	; assume down
	mov		bx, (Cols+1)*3*2
	
	; test if bit 0 is set ( 1 or 3, down/up )
	test	al, 1
	jnz		con15
	mov		bl, 3
	
con15:
	cmp		al, 2	; if < 2 do not negate
	jl		con45
	neg		bx
	
; do the action..
con45:

	add		bx, di
	cmp		byte ptr [bx], '|'
	jne		con49					;jump if visited
	
	push	di
	xchg	bx, di
	add		bx, di
	sar		bx, 1
	
	mov		word ptr [bx], 2020h

	call	ConFrom						;connect rest of cells starting from here
	pop		di
	
con49:	

;Next direction

	
	inc		ax
	and		al, 3h
	
	loopw	con10

	pop		ax
	ret


;-------------------------------------------------------------------------------
;Return random number
Ran:	
	
	mov		ax, 4E35h
	imul	dx
	inc		ax
	mov		dx, ax
	xchg	al, ah
	

	ret


		
		
;Str1	db	"+--"	;ceiling
;Str2	db	"+  "	;no ceiling
;Str3	db	"|  "	;left wall
;Str4	db	"   "	;no wall

; '+' == 02Bh
; '-' == 02Dh
; ' ' == 020h
; '|' == 07Ch

		
		
        end start