;for hugi compo #29 - random mazes - 169 bytes
;nasmw -o  m.com   m.asm
;>nasmw -v
; NASM version 0.98.38 compiled on Sep 12 2003
;;

; Una casella e' la seguente scrittura
; +--
; |XY

; quindi e' formata da 6 chars.
; A significa *non visitato*, se a posto di A ci sta un qualsiasi altro
; carattere significa visitato.


; +--+--+--+
; |  |3 |  |
; +--+--+--+
; | 2|AA|0 |
; +--+--+--+
; |  |1 |  |
; +--+--+--+

; L == lunghezza in caselle del rettangolo del labirinto
; H == altezza   in caselle del rettangolo del labirinto

;;

%define   L   25
%define   H   10

; massimi valori
;%define   L    40
;%define   H    40

%define   BytesMemory    ((L+1)*(H+2)*6)
%define   H21            (2*H+1)
%define   sopra          (L+1)*6
%define   sopra2         (L+1)*3


          org     100h
Start:
;  ****************************
;  ***  Prende il numero with the help by Esra Sdrawkcab
;  ****************************
          mov     si,  081h
          mov     bl,  ' '      ; bx==0    and  ax=0
.0:       aad     10            ; al=al+10*ah e ah=0
          mov     ah,  al
          lodsb
          sub     al,  bl
          mov     bl,  '0'      ; prima ' ' poi '0'
          jge     .0
          mov     bl,  ah       ; inizializza il seed==bx per rand
;  *******************************************
;  *** Fa la griglia
;  *******************************************
          mov     di,  arr
          mov     bp,  H21
          mov     ax,  "+-"
          mov     dx,  "||"
          push    di            ; conserva per la stampa
.2:       mov     cl,  L        ; altrimenti visitate
.3:       stosw
          mov     byte[di],  ah
          inc     di
          loop    .3
          stosb
          mov     word[di],  0a0dh
          scasw                 ; fa la linea
          xchg    ax,  dx
          dec     bp
          jnz     .2            ; passa alla linea successiva
          mov     byte[di],  '$'
          mov     byte[di-sopra2-3],  07fh
          xchg    ax,  si
          xchg    ax,  cx
          inc     di
          rep     stosw         ; 40x2=80 < 082h
; **************************************
; *** Trova una casella casuale
; **************************************
;  P(x,y)=j_inz+y*(L+1)*6+x*3
          mov     cl,  L
          call    ran
          imul    bp,  dx,  byte  3 ; x*3
          mov     cl,  H
          call    ran
          imul    ax,  dx,  sopra ; y*(L+1)*6
          mov     di,  (arr+sopra2)
          mov     byte[di],  02h
          add     ax,  bp
          add     di,  ax
;  *******************************************
;  *** Fa il labirinto
;  *******************************************
          inc     di
.4:       mov     word[di],  "  " ;  "  " significa visitata
.5:       mov     cl,  4
          call    ran           ; le caselle confinanti sono 4
.6:       and     dl,  3        ; dl=0[destra],1[basso], 2[sinistra],3[alto]
          mov     bp,  dx
          mov     al,  [muro+bp]
          cbw
          imul    bp,  ax,  byte  2
          test    dl,  1
          jnz     .6b
          dec     bp
.6b:      cmp     word[di+bp],  si
          je      .a            ; se tale casella non e' visitata va in .a
.7:       inc     dx
          loop    .6            ; vai alla prossima casella
                ; ** caso le caselle sono tutte visitate
          cmp     sp,  0FFFCh
          jae     .z            ; se lo stack e' vuoto esci
          pop     dx
          pop     di            ; altrimenti prende la casella precedente
          mov     cl,  4
          jmp     short  .7
%if BytesMemory>24000
.e:       int     20h           ; nel caso di errore non stampa proprio niente:
; ritorna al DOS
%endif
.a:            ; ** caso vi  una casella non visitata
          xchg    ax,  bp
          mov     word[di+bp],  "  " ; leva il muro di divisione
%if BytesMemory>24000
          cmp     sp,  limite
          jbe     .e            ; lo stack non puo' invadere la memoria
%endif
          push    di
          push    dx
          add     di,  ax
          jmp     short  .4
.z:
;   ******************************
;   *** Stampa sullo schermo
;   ******************************
          pop     dx
          mov     ah,  09h
          int     21h
          ret

; ritorna un numero 0..cx in dx
ran:
          imul    bx,  bx,  04e35h
          inc     bx
          movzx   ax,  bh
          cwd
          idiv    cx
          ret

muro   db   2,  sopra2, -1, -sopra2

          Section   .bss
arr    resb BytesMemory
fine   resb 128 ; stack riservato al MSDOS
limite resb 4

