/*
 * Submission verifier for Hugi competition 29 -- Tapani Utriainen 2009
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static const char *facitname = "example.com";
static const char *progname[] = { "entry.com ", "entry ", "entry.com  ", "entry    ", " entry.com ", "  entry    ", "ENTRY.COM ", "ENTRY ",  
   "ENTRY  ","ENTRY \t"," ENTRY.COM ","   ENTRY.COM\t","\tENTRY.COM\t"," \t ENTRY.COM \t \t "," \t entry.com \t "," \t entry.com \t\t" };

/* ------------------------------------------------------------------------ */

int main(int argc, char **argv) {
   short i, fail, linecount, linepos, argno;
   int verbose, tough;
   char command1[256], command2[256], line1[80], line2[80], *s;
   FILE *f1, *f2;
   
   verbose = tough = 0;
   for (argno=1; argno<argc; argno++) {
      if (!strcmp(argv[argno], "-v")) verbose = !verbose; else
      if (!strcmp(argv[argno], "-t")) tough = !tough;
   }
   
   if (verbose) {
      if (tough) printf("Starting tough test...\n");
      else printf("Starting standard test...\n");
   }

   /* Check if example.com and entry.com exist in current folder */
   if (!(f1 = fopen(facitname, "rb"))) {
      printf("ERROR: Failure executing %s. File not found?\n", facitname);
      fail = 1; goto out;
   } else fclose(f1);

   if (!(f1 = fopen("ENTRY.COM", "rb"))) {
      printf("ERROR: Failure executing ENTRY.COM\n");
      fail = 1; goto out;
   } else fclose(f1);

   /* Delete any previous runs */
   if (f1 = fopen("tested.maz", "r")) { fclose(f1); system("del tested.maz"); }
   if (f1 = fopen("answer.maz", "r")) { fclose(f1); system("del answer.maz"); }
         
   if (verbose) printf("Testing seeds:");
   /* Seed -1 means no seed argument given */
   for (i=-1; i<=100; i++) {
      fail = 0;
      /* Prepare commands to run, depending on seed and toughness */
      if (i<0) {
         sprintf(command1, "%s > answer.maz", facitname);   
         if (tough) sprintf(command2, "%s > tested.maz", progname[i&15]);
         else sprintf(command2, "%s > tested.maz", progname[i&1]);
      } else {
         sprintf(command1, "%s %i > answer.maz", facitname, i);
         if (tough) sprintf(command2, "%s%03i  >  tested.maz", progname[i&15], i);
         else sprintf(command2, "%s%i > tested.maz", progname[i&1], i);            
      }
      /* Execute example, and check if answer present */
      system(command1);
      if (verbose && i >= 0) { printf(" %i", i); fflush(stdout); }
      f1 = fopen("answer.maz", "r");
      if (!f1) {         
         printf("ERROR: Example does not redirect output properly? Disk full?\n");
         if (verbose) printf("Failing command: \"%s\"\n", command1);
         fail = 1; goto out;
      }
      
      /* Execute entry, and check for output file */
      system(command2);
      f2 = fopen("tested.maz", "r");
      if (!f2) {         
         printf("ERROR: Entry does not redirect output properly.\n");
         if (verbose) printf("Failing command: \"%s\"\n", command2);
         fclose(f1); fail = 1; goto out;
      }
      
      /* Compare the outputs line by line */
      linecount = 0;
      while (!feof(f1)) {
         linecount++;         
         s = fgets(line1, 79, f1);
         if (fgets(line2, 79, f2) == NULL && s != NULL) {            
            printf("\nERROR: Too few lines outputed from entry ");
            if (i>=0) printf("for seed %i.\n", i); else printf("when no seed given.\n");
            if (verbose) printf("Failing command: \"%s\"\n", command2);
            fclose(f1); fclose(f2);
            fail = 1; goto out;
         } else {
            /* Compare corrseponding lines character by character */
            linepos = 0;            
            while (line1[linepos] != 0) {
               if (line2[linepos] == 0 || line1[linepos] != line2[linepos]) {                  
                  printf("\nERROR: Output on line %i column %i differs ", linecount, linepos+1);
                  if (i>=0) printf("for seed %i.\n", i); else printf("when no seed given.\n");
                  if (verbose) printf("Failing command: \"%s\"\n", command2);
                  fclose(f1); fclose(f2);
                  fail = 1; goto out;
               }
               linepos++;
            }
            if (line2[linepos] != 0) {
               printf("ERROR: Line %i too long ", linecount);
               if (i>=0) printf("for seed %i.\n", i); else printf("when no seed given.\n");
               if (verbose) printf("Failing command: \"%s\"\n", command2);
               fclose(f1); fclose(f2);
               fail = 1; goto out;
            }
         }         
      }
      if (!feof(f2)) {
         fail = 1;
         printf("ERROR: Too few lines outputed from entry ");
         if (i>=0) printf("for seed %i.\n", i); else printf("when no seed given.\n");
         if (verbose) printf("Failing command: \"%s\"\n", command2);
         goto out;
      }
      fclose(f1);
      fclose(f2);
   }
   if (verbose) printf("\n");
out:
   if (fail) {
      if (tough) printf("Entry failed the tough test.\n");
      else printf("Entry failed a standard test.\n");
      if (!verbose) printf("Use a \"-v\" flag for verbose information.\n");
   } else {
      if (tough) printf("Entry passes tough test :-)\n");
      else printf("Entry passes a standard test. :)\n(How about trying the tough test using a \"-t\" flag :)\n");   
   }

   if (f1 = fopen("tested.maz", "r")) { fclose(f1); system("del tested.maz"); }
   if (f1 = fopen("answer.maz", "r")) { fclose(f1); system("del answer.maz"); }
   return 0;
}

