/* Hugi size compo #2 - docom by VectoR/DataKrackers (ilppis@freenet.hut.fi)
 *
 * Platform:
 *			It's designed to run/compile at least on Linux ELF (GCC 2.7.2.1)
 *			but it might work on other unices too... Should also compile with
 *			minimal changes on DOS/WIN too...
 *
 * Limitations:
 *			Constant input filenames assumed... #define controls "size"... :-(
 *
 * In:
 *			infoSIZE.0 ... Critical info required for stream creation
 *			streamSIZE.0 . the stream
 *			usedSIZE.0 ... multiple char entries
 *			new1.com .... DOS comfile
 *
 * Out:
 *			result.com .. resulting DOS executable comfile
 *
 * Important notes:
 *			Can only handle output files exactly like ones from comp!
 *
 * Description:
 *			Read all necessary data and inserts it to comfile and also fixups
 *			some code inside the comfile... (sizes and stuff)
 *
 * TODO:
 *			*Get it working... :-)
 */


#include <stdio.h>

//#define DEBUG
//#define LOADDEBUG
#define SIZE 503

unsigned char	single0[ 16 ];
unsigned char	single1[ 16 ];

unsigned char	ucases[ 1024 ];

unsigned char	buffer[ 1024 ];

unsigned char	output[ 1024 ];

typedef struct {
	int	stream;
	int	single0;
	int	single1;
	int	multisize;
	int	multicount;
	int	chars;
	int	bit12;
	int	ucases;
}CRIT;

CRIT	crit;

typedef struct {
	int	size;
	int	packed;
	int	origsize;
	int	len;
	unsigned char	data[ 32 ];
}MULTI;

MULTI	multi[ 100 ];

typedef struct {
	int size;
	void *ptr;
}FIXUP;

int	dataoffs, singleoffs, dualoffs, multioffs;
int	savedcrlf = 0xd, notsavedcrlf = 0xa;	/* assume these */
int	multiinfo, ucaseoffs, ucasecount, end;

FIXUP	fixup[ 10 ] = { 
{2, &dataoffs}, 
{2, &crit.chars},
{2, &ucaseoffs},
{1, &ucasecount},
{2, &multioffs},
{2, &singleoffs},
{2, &dualoffs},
{2, &multiinfo},
{1, &savedcrlf},
{1, &notsavedcrlf}
};

int	last, size, comsize, origsize; 
int	multis = 0;

void	decrypt(char *where, int count);
void	extractmulti();
void	loaddata( int ssize );

char	comfile[] = "new1.com";


void	main()
{
	FILE	*out;
	int	i, a, temp;

	loaddata( SIZE );

	comsize = origsize;

	dataoffs = comsize;		/* (* 2!!, TASM couldn't assemle it) */
	memcpy( &(output[ comsize ]), &(buffer[0]), crit.stream );
	comsize += crit.stream;

	ucaseoffs = comsize;
	ucasecount = crit.ucases;
	for( i = 0; i < crit.ucases; i++ )
	{
		output[ comsize++ ] = ucases[ i + 1 ];
	}

	singleoffs = comsize;
	memcpy( &(output[ comsize ]), &(single0[0]), 15 );
	comsize += 15;

	dualoffs = comsize;
	memcpy( &(output[ comsize ]), &(single1[0]), 15 );
	comsize += 15;

	multiinfo = comsize - 1;		/* -1 !!! */
	comsize += last;

	multioffs = comsize;
	for( i = 0; i < last; i++ )
	{
		output[ multiinfo + multi[ i ].packed ] = (comsize - multioffs) * 2;

		printf( "Writing %01x to %03x\n", multi[ i ].packed, comsize + 0x100 );
		decrypt( &(multi[ i ].data[0]), multi[ i ].origsize );
		printf( "\n" );

		temp = (multi[ i ].origsize);
		for( a = 0; a < (multi[ i ].len+7)/8; a++ )
		{
			temp += (multi[ i ].data[ a ] << 4);
			printf( "%01x %01x  ", temp & 0xf, (temp >> 4) & 0xf );
			output[ comsize++ ] = temp & 0xff;
			temp >>= 8;
			temp &= 0xf;
		}
		if( temp )		/* can't be zero! (it's our multi data starting byte) */
			output[ comsize++ ] = temp & 0xff;
		printf( "\n" );
	}
	end = comsize;

/*	printf( "Comsize: t: %i; c: %i; d: %i; s: %i; m: %i;\n", comsize, origsize, dataoffs, singleoffs, multioffs );
	if( crit.bit12 )
		printf( "using 12-bit...\n" );
	printf( "multis: e: %i; m: %i; diff: %i\n", end, multioffs, end-multioffs );
	printf( "uc: %i; s: %i\n", ucaseoffs, singleoffs - ucaseoffs );
*/


	dataoffs = (dataoffs + 0x100) * 2;	/* special case */
	singleoffs += 0x100 - 1;		/* -1 !!! */
	dualoffs += 0x100 - 1;			/* -1 !!! */
	ucaseoffs += 0x100;
	multiinfo += 0x100;
	multioffs = (multioffs + 0x100) * 2;	/* special */


	a = 0;
	for( i = 0; i < origsize; i++)
	{
		if( output[ i ] == 0xff )
		{
			/* check if call rel16 */
			if( output[ i - 2 ] == 0xe8 ) continue; 

			printf( "offset: %x\n", i + 0x100 );

			if( a >= 10 ) printf( "Error in comfile!\n" );

			if( fixup[ a ].size > 1 )
				if( output[ i ] != 0xff )
					continue;

			memcpy( &(output[ i ]), fixup[ a ].ptr, fixup[ a ].size );

			if( fixup[ a ].size > 1 ) 
				i++;
			a++;
		}
	}


	printf( "Comfile statistics:\n" );
	printf( "\tcode start: %03x\n", 0x100 );
	printf( "\tstream start: %03x\n", origsize + 0x100 );
	printf( "\tucase start: %03x\n", ucaseoffs );
	printf( "\tsingle start: %03x\n", singleoffs );
	printf( "\tmulti start: %03x\n", multiinfo );
	printf( "\tMULTI OFFS: %03x\n", multioffs );
	printf( "\tEND: %03x\n\n", end + 0x100 );

	printf( "Writing result!\n" );

	out = fopen( "result.com", "wb" );
	if( out == NULL ) {printf( "error\n" ); exit( 1 );}
	fwrite( output, 1, end, out );
	fclose( out );

}

void	decrypt(char *where, int count)
{
	int	i, temp, index, src;
	int	a, b, c;
	temp = src = index = c = 0;


	while( c < count )
	{
		while( index < 16 )
		{
#ifdef DEBUG
			printf( "\nL %.3i %02x !", src, where[ src ] & 0xff );
#endif
			temp = temp + ((int)(where[ src++ ]) << index);
			index += 8;
			temp &= (1 << index) - 1;
		}
		if( (temp & 0xff) == 0x00 )
		{
			a = (temp >> 8) & 0xf;
			for( b = 0; b < last; b++ )
			{
				if( multi[ b ].packed & 0xf == a )
					break;
			}
#ifdef DEBUG
			printf( "\n\t\tP %04x :\t", temp & 0xffff );
#endif
			decrypt( &(multi[ b ].data[0]), multi[ b ].origsize );
			index -= 12;
			temp >>= 12;
		}
		else if( (temp & 0xf) == 0x0 )
		{
#ifdef DEBUG
			printf( "\n\t\tP %02x :\t", temp & 0xff );
#endif
			printf( "%c", single1[ ((temp-1) >> 4) & 0xf ] );
			index -= 8;			
			temp >>= 8;
		}else
		{
#ifdef DEBUG
			printf( "\n\t\tP %01x :\t", temp & 0x0f );
#endif
			printf( "%c", single0[ (temp-1) & 0xf ] );
			index -= 4;
			temp >>= 4;
		}
		if( index < 0 ) printf( "Warning: negative index!!!\n" );
		if( !index ) temp = 0;		/* bug fixer */
		temp &= ((1 << index) - 1);	/* bug fixer, clear hibits */
		c++;
	}


}

void	extractmulti()
{
	int	i, temp;
	temp = 0;
	printf( "l: %i\n", last );

	for( i = 0; i < last; i++)
	{
		multi[ multis ].packed = buffer[ temp + 1 ];
		multi[ multis ].size = 16;
		multi[ multis ].origsize = buffer[ temp + 2 ];
		multi[ multis ].len = buffer[ temp + 3 ];
		memcpy( &(multi[ multis ].data[0]), &(buffer[temp+4]), (multi[ multis ].len+7)/8 );

#ifdef LOADDEBUG		
		decrypt( &(multi[ i ].data[0]), multi[ i ].origsize );
		printf( "\n");
#endif


		temp += (multi[ multis++ ].len+7)/8 + 4;
	}

	if( multis != last ) printf( "m: %i vs l: %i!\n", multis, last );

}


void	loaddata( int ssize )
{
	char	filename[ 32 ];
	FILE	*in;
	int		temp;

	sprintf( filename, "info%03i.0", ssize );
	printf( "Reading file %s...\n", filename );

	in = fopen( filename, "rb" );
	if( in == NULL ) {printf( "error\n" ); exit( 1 );}
	fread( &(crit), sizeof( CRIT ), 1, in );
	fclose( in );

	in = fopen( "single.0", "rb" );
	if( in == NULL ) {printf( "error\n" ); exit( 1 );}
	fread( single0, 1, 15, in );
	fclose( in );
	in = fopen( "single.1", "rb" );
	if( in == NULL ) {printf( "error\n" ); exit( 1 );}
	fread( single1, 1, 15, in );
	fclose( in );

	in = fopen( "ucase.lst", "rb" );
	if( in == NULL ) {printf( "error\n" ); exit( 1 );}
	fread( ucases + 1, 1, 1024, in );
	fclose( in );
	ucases[ 0 ] = 0;


	sprintf( filename, "used%03i.0", ssize );
	printf( "Reading file %s...\n", filename );

	in = fopen( filename, "rb" );
	if( in == NULL ) {printf( "error\n" ); exit( 1 );}
	temp = fread( buffer, 1, 1024, in );
	fclose( in );

	size = crit.stream;
	last = crit.multicount;

	printf( "Extractmulti() - going in...\n" );
	extractmulti();
	printf( "Done with it!\n" );

	sprintf( filename, "stream%03i.0", ssize );
	printf( "Reading file %s...\n", filename );

	in = fopen( filename, "rb" );
	if( in == NULL ) {printf( "error\n" ); exit( 1 );}
	fread( buffer, 1, crit.stream, in );
	fclose( in );

	printf( "Reading file %s...\n", comfile );

	in = fopen( comfile, "rb" );
	if( in == NULL ) {printf( "error\n" ); exit( 1 );}
	origsize = fread( output, 1, 1024, in );
	fclose( in );

	for( temp = 0; temp < 15; temp++ )
	{
		if( single0[ temp ] == 0xa ) single0[ temp ] = 0xd;
	}

}
