.model tiny
.code
.386
;
; 92 bytes VGA 640x480 life program
;	
;      	     	   
;      	   	 
;	     
; by INT-E
;		 
; if anyone knows how to get this
; smaller please let me	know
;
; bf3@irz.inf.tu-dresden.de
;
org	100h
s:	mov al,12h					; mode 640x480x16
	int 10h						; 5b init

m:	mov cx,0A000h					; A000>80*480
	mov es,cx
	mov si,offset e
	xor di,di					; start	of screen
							; 10b loop init
a:	mov ax,[si-80]					; last line
	call x						; "SUB"
	mov ax,[si]					; current line
	call x						; "SUB"
	mov ax,[si+80]					; next line
	call x						; "SUB"
							; 17b counting;	ah=0
	mov al,byte ptr	es:[di-80]
	mov byte ptr [si-80],al				; 7b copy screen -> buf
	lodsb						; current 8 pix
	or  al,bl					; 0,101	(=3)
	not dl						; 1,101	(=3)
	and al,dl					; 1,100	(=4)->1
	and ax,bp					; other	    ->0
	stosb						; 10b evaluate
	shr bx,8					; shift	sums
	shr dx,8					; zero fill
	shr bp,8					; 9b
	loop a						; 2b do	A000 times

	in al,60h
	dec ax						; ESC pressed?
	jnz m						; 5b no	-> next	gen
	mov al,3					; text mode
	int 10h						; 4b done
							; ...ret
x:	push ax						; pixels:
	ror ax,1					; AX=89ABCDEF 01234567
	rcl al,1					; -> 789ABCDE 01234567
	call y						; single "SUB"
	pop ax
	rol ax,1
	mov ah,0					; -> -------- 12345678
							; 13b rotate pixels
y:	xor bx,ax					; bx: bit 0 counter
	and ax,bx
	xor dx,ax					; dx: bit 1 counter
	and ax,dx
	xor bp,ax					; bp: bit 2 counter
	ret						; 11b single "SUB"
	db 160 dup (?)					; only 80 are actually
e:							; needed
end s
