uses CRT;
{
| compressor
|
| for HUGI compo 2
|
| by INT-E
|
| Have fun!
}
const
(*  expand {$I expand.inc};*)
  maxbits=10;
  max=1024;

type
  ttree=record
    left,right:Word;
    count:Word;
    win:Word;
  end;

var
  tree:array[0..511]of ttree;
  rtree:array[0..511]of word;
  tbits:array[0..511]of byte;
  reverse:array[0..255]of Byte;
  src,use:array[0..max-1]of byte;
  len,del:array[0..max-1]of word;
  count,top:word;
  bits:byte;
  g:text;
  _size:word;

function min(a,b:Integer):Integer; begin if a<b then min:=a else min:=b end;

procedure calctree;
var
  m1,m2,i1,i2,i:Word;
begin
  top:=256;
  repeat
    m1:=65535;m2:=65535;i1:=0;i2:=0;
    for i:=0 to top-1 do if tree[i].count>0 then begin
      if tree[i].count<m1 then begin m2:=m1;i2:=i1;m1:=tree[i].count;i1:=i end else
      if tree[i].count<m2 then begin m2:=tree[i].count;i2:=i end;
    end;
    if m2<65535 then begin
      tree[top].right:=i1;tree[top].left:=i2;tree[top].count:=m1+m2;
      tree[i1].count:=0;tree[i2].count:=0;
      Inc(top);
    end;
  until m2=65535;
  top:=i1;
  fillchar(rtree,sizeof(rtree),0);
  for i:=256 to top do begin
    rtree[tree[i].left]:=i;rtree[tree[i].right]:=i;
  end;
  tbits[top]:=0;tbits[0]:=254;
  for i:=top-1 downto 0 do tbits[i]:=1+tbits[rtree[i]];
end;

procedure findmax;
var
  size:array[0..max-1]of Word;

  procedure calcmax;
  var
    i,l:Word;
  begin
    i:=count;
    size[i]:=0;
    while i>0 do begin
      Dec(i);
      size[i]:=size[i+1]+tbits[src[i]];
      use[i]:=0;
      l:=len[i];
      if (l>0) and (size[i+1]+tbits[src[i]]>size[i+l]+tbits[256-l]+bits) then begin
        use[i]:=size[i+1]+tbits[src[i]]-size[i+l]+tbits[256-l]+bits;
        size[i]:=size[i+l]+tbits[256-l]+bits;
      end;
    end;
  end;

begin
  calcmax;
end;

procedure usage;
var
  i:Word;
begin
  _size:=0;
  for i:=0 to 255 do tree[i].count:=0;
  for i:=0 to 255 do tree[i].win:=0;
  i:=0;
  while i<count do begin
    if use[i]>0 then begin
      Inc(tree[256-len[i]].count);
      Inc(tree[256-len[i]].win,use[i]);
      _size:=_size+bits+tbits[256-len[i]];
      i:=i+len[i];
    end else begin
      Inc(tree[src[i]].count);
      _size:=_size+tbits[src[i]];
      Inc(i);
    end;
  end;
end;

procedure init;
var
  i,j,k,l,m,n:word;
  IFN,OFN:string;
  f:file;
begin
  if ParamCount=0 then IFN:='TEXT.TXT' else IFN:=ParamStr(1);
  i:=Length(IFN);Write(IFN,'=>');
  OFN:='EXPAND.DAT';
  assign(f,IFN);reset(f,1);
  blockread(f,src,max-3,count);
  close(f);
  src[count]:=Byte('$');Inc(count);
  for i:=0 to count-1 do begin
    k:=0;l:=0;
    for j:=1 to min(i,1 shl bits) do begin
      m:=0;
      while (src[i+m]=src[i-j+m]) and (m<count-i) and (m<31) do inc(m);
      if m>l then begin l:=m;k:=j; end;
    end;
    len[i]:=l;del[i]:=k;
  end;
  reverse[0]:=0;
  for i:=1 to 255 do reverse[i]:=reverse[i shr 1] shr 1+(i and 1)*128;
  assign(g,OFN);rewrite(g);
  writeln(g,'; expand include file generated by compress');
end;

procedure fixtree;
var
  i:Word;
begin
  i:=src[0];
  while rtree[i]<>top do i:=rtree[i];
  if i=tree[top].left then begin
    tree[top].left:=tree[top].right;tree[top].right:=i;
  end;
  i:=top;
  while i>255 do i:=tree[i].left;
end;

procedure writeout;
var
  buf:array[0..1023] of Byte;
  col:Byte;
  s,b:Byte;
  idx:Word;

  procedure writebyte(a:byte);
  begin
    if col=0 then write(g,'  db ') else write(g,',');
    write(g,a:3);col:=col+1;if col=16 then begin writeln(g);col:=0; end;
  end;

  procedure putbit(a:Byte);
  begin
    s:=s shr 1+a*128;Inc(b);
    if b=8 then begin
      buf[idx]:=s;Inc(idx);
      b:=0;s:=0;
    end;
  end;

  procedure writedata;
  var
    i,j,d:Word;

    procedure putbyte(node:word);
    begin
      if node=top then exit;
      if node=0 then begin writeln('FATAL ERROR in PUTBYTE!');close(g);
        asm int 3 end;halt;
      end;
      putbyte(rtree[node]);
      if tree[rtree[node]].left=node then putbit(0) else putbit(1);
    end;

  begin
    col:=0;b:=255;s:=0;idx:=0;
    i:=0;
    while i<count do begin
      if use[i]>0 then begin
        putbyte(256-len[i]);
        for j:=bits-1 downto 0 do
          if (65536-del[i]) and (1 shl j)>0 then putbit(1) else putbit(0);
        i:=i+len[i];
      end else begin
        putbyte(src[i]);i:=i+1;
      end;
    end;
    while b>0 do putbit(0);
    for i:=idx downto 0 do writebyte(reverse[buf[i]]);
    if col<>0 then writeln(g);
  end;

  procedure writetree;
    procedure walk1(node:Word);
    begin
      if node>255 then begin
        putbit(1);walk1(tree[node].left);walk1(tree[node].right);
      end else putbit(0);
    end;

    procedure walk2(node:Word);
    begin
      if b=8 then begin b:=0;s:=buf[idx];writebyte(buf[idx]);Inc(idx);end;
      Inc(b);
      if node>255 then begin
        if s and 1=0 then asm
          int 3
        end;
        s:=s shr 1;
        walk2(tree[node].left);walk2(tree[node].right);
      end else begin
        if s and 1=1 then asm
          int 3
        end;
        s:=s shr 1;
        if node>127 then writebyte(s xor node) else writebyte(node);
      end;
    end;

  begin
    writeln('EXPAND.DAT');
    col:=0;b:=255;s:=0;idx:=0;
    walk1(top);
    while b>0 do putbit(0);
    b:=7;s:=1;idx:=0;
    walk2(top);
    if col<>0 then writeln(g);
  end;

begin
  writeln(g,'data:');
  writedata;
  writeln(g,'tree:');
  writetree;
  writeln(g,'BITS=',bits);
  writeln(g,'COUNT=254+8*(OFFSET tree-OFFSET start)');
  writeln(g,'; EOF');
end;

procedure done;
begin
  close(g);
end;

var
  i,j:Integer;

begin
  bits:=9;
  init;
  randomize;
  for i:=0 to 127 do tbits[i]:=80;
  for i:=128 to 255 do tbits[i]:=0;
  for j:=0 to 50 do begin
    findmax;
    usage;
    if (j<30) or (j=31) then
      for i:=128 to 255 do if tree[i].count>0 then
        if tree[i].win<900 then tree[i].count:=1;
    if (j<10) or (j=11) then for i:=128 to 255 do
      if tree[i].count=0 then
        tree[i].count:=1;
    calctree;
    write('.');
  end;
  findmax;
  usage;
  fixtree;
  writeout;
  done;
  writeln(_size,' bits, ',top-254,' chars');
end.
{
 TODO:
  -find a better way to optimize compressing
  -try to overlap code and data
  ...
}
