;GHALI
;
;Decompressor size: 130 bytes
;Total size: 552 bytes
;Method: An LZ77 similar technique applied on 4-bit packed decapitalized data.
;
;Max Bennedich, 06/98
;max-b@algonet.se

code    segment
org     100h
assume  cs:code,ds:code,es:code
.386

Ghali:

;* init
        lea  si,CData
        mov  di,8000h-903
        mov  dl,20h
        push di
        jmp  Nxt


; MAIN DECOMPRESSION LOOP 
;* find the sequence this code represents and write it to buffer
LZ:     call UnPackByte        ;length
        xchg ax,cx
        call UnPackByte        ;low offset
        add  al,5
        mov  bx,ax
        call UnPackByte        ;high offset
        push si

        shl  ax,4
        add  bx,ax
        mov  si,di
        sub  si,bx
        rep  movsb
        pop  si


;* read next byte
Nxt:    mov  bx,offset Tbl
UPck:   call UnPackByte

        xlatb
        dec  ax
        jz   LZ
        mov  bl,offset Tbl2 - 100h
        cmp  al,0dh
        jl   UPck
        jnz  Write

        stosb
        mov  al,0ah


;* capitalize and write unpacked byte to buffer
Write:  cmp  al,'.'+32
        jz   UPPER
        cmp  al,'?'+32
        jb   NoLettr
        jnz  lower
UPPER:  mov  dl,32
lower:  sub  al,dl
        and  dl,al

NoLettr:mov  [di],al
        inc  di
        jns  Nxt
; END MAIN DECOMPRESSION LOOP 


;* write to screen
        mov  ax,924h
        stosb
        pop  dx
        int  21h


;* unpack 4-bit to 8-bit
UnPackByte:
        lodsb
        neg  dh
        jns  Odd
        shr  al,4
        dec  si
Odd:    and  al,0fh
        ret


Tbl label byte
db 'e'+1, 'u'+1, 't'+1, 'h'+1, 'i'+1, 'a'+1, ' '+1, 'l'+1, 'm'+1, 'n'+1, 'o'+1, 1, 0dh+1, 'r'+1, 's'+1, 0ah+1

Tbl2 label byte
db 'k'+1, 'b'+1, 'c'+1, 'd'+1, 'g'+1, 'p'+1, 'q'+1, '.'+32+1, ','+1, '?'+32+1, 'f'+1, 'v'+1, 'w'+1, '-'+1, 'y'+1

CData label byte


code    ends
END     Ghali
