    ; Simple encoder (only works with files <=1024 bytes)
    ; Written by Roland Neul
    ; Assemble with: nasm -f bin -o encode.com encode.asm
    ; Last changed: 14.06.98

    org 0100h

    ; Get filename
    mov bl,[80h]
    xor bh,bh
    add bx,81h
    mov BYTE [bx],0

    ; Open file
    mov dx,82h
    mov ax,3D00h
    int 21h
    jc NEAR foerr
    mov bx,ax
    ; Read file
    mov ah,3Fh
    mov cx,1024
    mov dx,buffer
    int 21h
    jc NEAR frerr
    mov [size],ax
    ; Close file
    mov ah,3Eh
    int 21h

    mov si,buffer
    mov bx,[size]
    mov BYTE [bx+si],0
    inc WORD [size]
    mov di,data
    xor edx,edx
    xor bp,bp
cloop:
    ; Get char
    lodsb
    dec WORD [size]
    ; ignore linefeed
    cmp al,10
    je .ignore
    ; Seek in chartab
    push di
    mov di,chartab
    mov cx,38
    repne scasb
    inc cx
    pop di
    sub cx,38
    neg cx
    ; get code
    mov bx,cx
    mov cl,[bx+lentab]
    shl edx,cl
    shl bx,2
    or edx,[bx+codetab]
    add bp,cx
    cmp bp,8
    jae .store
.ignore:
    cmp WORD [size],0
    jg cloop
    jmp SHORT .exit
.store:
    ; Store 1 byte
    push edx
    sub bp,8
    mov cx,bp
    or cx,cx
    jz .is8
    shr edx,cl
.is8:
    mov [di],dl
    inc di
    inc WORD [dsize]
    pop edx
    ; Another byte ready?
    cmp bp,8
    jae .store
    cmp WORD [size],0
    jg cloop
.exit:
    ; If needed, store rest data
    or bp,bp
    jz .noleft
    mov cx,bp
    sub cx,8
    neg cx
    shr edx,cl
    mov [di],dl
    inc WORD [dsize]
.noleft:

    ; Save data
    mov dx,dfname
    mov ah,3Ch
    xor cx,cx
    int 21h
    jc foerr
    mov bx,ax
    mov cx,[dsize]
    mov dx,data
    mov ah,40h
    int 21h
    jc fwerr
    mov ah,3Eh
    int 21h

exit:
    ; Quit program
    mov ax,4C00h
    int 21h

foerr:
    mov dx,err00
    mov ah,09h
    int 21h
    jmp SHORT exit
frerr:
    mov dx,err01
    mov ah,09h
    int 21h
    jmp SHORT exit
fwerr:
    mov dx,err02
    mov ah,09h
    int 21h
    jmp SHORT exit

dfname
    db 'text.enc',0

err00    db 'Error opening file!',13,10,'$'
err01    db 'Error reading file!',13,10,'$'
err02    db 'Error writing file!',13,10,'$'

size
    dw 0
dsize
    dw 0
buffer
    TIMES 1024 db 0
data
    TIMES 1024 db 0

chartab
    db ' eaoltnrish',13,'pfmydcu.wvg,kS?PT-BINOYq',0
lentab
    db 2,3,4,4,4,4,5,5,5,5,5,5,5,5,6,6,6,6,7,7,7,7,7,7,8,8
    db 9,9,10,10,11,11,12,12,12,13,13
codetab
    dd 00b
    dd 010b
    dd 0110b, 0111b, 1000b, 1001b
    dd 10100b, 10101b, 10110b, 10111b
    dd 11000b, 11001b, 11010b, 11011b
    dd 111000b, 111001b, 111010b, 111011b
    dd 1111000b, 1111001b, 1111010b, 1111011b, 1111100b, 1111101b
    dd 11111100b, 11111101b
    dd 111111100b, 111111101b
    dd 1111111100b, 1111111101b
    dd 11111111100b, 11111111101b
    dd 111111111100b, 111111111101b, 111111111110b
    dd 1111111111110b, 1111111111111b

