; 621 Byte Text Compression program by Andrew Nicolle (aka raven/tektonic)
; coded 2 July 1998 for hugi size coding compo #2

; USAGE: The program prints a text message (text.txt) that has been
;        compressed in the com file.

; ===< Contact Info >===
; Email: andrewn@cobweb.com.au
; Web:   http://www.cobweb.com.au/~andrewn

; History: 28/6/98 - 781 bytes (using Hash-predictor compression)
;          1/7/98 - 625 bytes (switched to sliding window compression)
;          2/7/98 - 621 bytes

Ideal
model tiny
p286


CODESEG
ORG 100h

UNPACK  = 2048      ; offset of unpacked data
WINDOW  = 4096      ; location of sliding window


START:

       mov     di,UNPACK
       push    di             ; save location where we'll put unpacked data
       mov     si,offset TEXTDATA ; si points to packed data
       inc     ah             ; ah = bit mask

unpack_loop:                  ; main unpacking loop

       mov     cl,1
       call    readbits       ; get flag bit
       jz      copy_window    ; jump if length/offset pair follows
       mov     cl,7
       call    readbits       ; read character (7-bits)
       mov     [di],dl        ; store character (unpacked)
       inc     di
       mov     [bx+WINDOW],dl ; store character in window
       inc     bx
       and     bh,1           ; make sure wrap-around considered
       jmp     unpack_loop

copy_window:

       mov     cl,3
       call    readbits       ; read length
       or      dx,dx
       jz      finished       ; zero length means end of data
       inc     dx             ; get correct length
       push    dx             ; store length
       mov     cl,9
       call    readbits       ; get window offset
       pop     cx             ; retrieve length
       push    ax
       mov     bp,dx

do_copy:                      ; character copy loop

       mov     al,[bp+WINDOW] ; get character from window
       stosb                  ; store character in unpacked section
       inc     bp
       and     bp,1FFh
       mov     [bx+WINDOW],al ; store character in window
       inc     bx
       and     bh,1
       loop    do_copy
       pop     ax
       jmp     unpack_loop

finished:

       mov     ax,9*256+'$'   ; Set ah=9 for string print and al='$' as
       stosb                  ; string terminator
       pop     dx             ; restore pointer to unpacked data
       int     21h
       ret

readbits: ; this function reads a certain number of bits into dx
	  ; parameter: cl = no. of bits to read
	  ; returns: dx = bits read

       xor     dx,dx

bitloop:

       shr     ah,1          ; ah must contain bit mask
       jnc     no_read       ; see whether to read another byte (bitmask=0)
       lodsb                 ; read another byte
       mov     ah,80h        ; reset bit mask

no_read:

       shl     dx,1
       test    al,ah         ; see if bit set
       jz      zero
       or      dl,1          ; set bit

zero:

       loop    bitloop
       ret

TEXTDATA: ; Compressed text data is pasted here by packdata program

END START
