#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define BSIZE   2
#define FSIZE   903

typedef
struct
{
        unsigned char   count;
        unsigned char   str[BSIZE + 1];
} SREC;

int scomp(const void *s1, const void *s2);
int ccomp(const void *n1, const void *n2);

int main(void)
{
        FILE    *F;
        unsigned char   *Buf, str[BSIZE + 1], key[BSIZE + 1];
        int     j, k, l;
        SREC    *ch, pat;

        Buf = (unsigned char *) malloc(sizeof(unsigned char) * FSIZE);

        F = fopen("TEXT.TXT", "rb");
        fread(Buf, sizeof(unsigned char), FSIZE, F);
        fclose(F);

        for (j = 0; j < FSIZE; j++)
        {
                if (Buf[j] == 0x0D)
                {
                        Buf[j] = '%';
                }
                else if (Buf[j] == 0x0A)
                {
                        Buf[j] = '@';
                }
        }

        ch = (SREC *) malloc(sizeof(SREC) * (FSIZE - BSIZE + 1));

        for (j = 0; j < (FSIZE - BSIZE + 1); j++)
        {
                for (k = 0; k < BSIZE; k++)
                {
                        ch[j].str[k] = Buf[j + k];
                }
                ch[j].str[BSIZE] = '\0';
                ch[j].count = 0;
        }

        for (j = 0; j < (FSIZE - BSIZE + 1); j++)
        {
                for (k = 0; k < (FSIZE - BSIZE + 1); k++)
                {
                        for (l = 0; l < BSIZE; l++)
                        {
                                str[l] = Buf[k + l];
                        }
                        str[BSIZE] = '\0';

                        if (strcmp(ch[j].str, str) == 0)
                        {
                                ch[j].count++;
                        }
                }
        }

        /* Pattern Search */
/*

        key[0] = ' ';
        key[1] = ' ';
        key[2] = '\0';
        k = 0;
        j = 0;
        str[2] = '\0';

        do
        {
                for (l = 0; l < BSIZE; l++)
                {
                        str[l] = Buf[j + l];
                }

                if (
                    (strcmp(key, str) == 0) &&
                    (j < (FSIZE - BSIZE + 1))
                   )
                {
                        k++;
                        j += BSIZE;
                }
                else
                {
                        j++;        
                }
        }
        while (j < (FSIZE - BSIZE + 1));

        printf("%d\n", k);
*/        
        qsort((void *) ch, (size_t) FSIZE - BSIZE + 1, (size_t) sizeof(SREC), ccomp);

        for (j = 0; j < (FSIZE - BSIZE + 1); j++)
        {
                printf("[%s] -> %4d\n", ch[j].str, ch[j].count);
        }
/*
        qsort((void *) Buf, (size_t) FSIZE, (size_t) sizeof(unsigned char), ccomp);

        for (j = 0; j < FSIZE; j++)
        {
                printf("[%c] -> 0x%02X\n", Buf[j], Buf[j]);
        }

        for (j = 0; j < (FSIZE - BSIZE + 1); j++)
        {
                l = 0;

                for (k = 0; k < (FSIZE - BSIZE + 1); k++)
                {
                        if (
                            (ch[j].str[0] == ch[k].str[0]) &&
                            (ch[j].str[1] != ch[k].str[1])
                           )
                        {
                                l = 1;
                        }
                }

                if (l == 0)
                {
                        printf("[%s] -> %4d *\n", ch[j].str, ch[j].count);
                }
        }
*/

        return 0;
}

int scomp(const void *s1, const void *s2)
{
        return strcmp((unsigned char *) s1, (unsigned char *) s2);
}

int ccomp(const void *n1, const void *n2)
{
        unsigned char   *x1 = (unsigned char *) n1,
                        *x2 = (unsigned char *) n2;
        
        if (*x1 > *x2)
        {
                return 1;
        }
        else if (*x1 < *x2)
        {
                return -1;
        }
        else
        {
                return 0;
        }
}
