{
  GENERATE
  Developed by Boo Khan Ming (Malaysia)

  Used to generate RUN.COM
  by compressing   TEXT.TXT
  and append it to TEMPLATE.COM


  The algorithm used here is 4-bit compression with extended supplementary
  code (BIT4E), which involves primary and extended compression.

  In primary compression, up to 14 different bytes with most occurrence
  able to be compressed into 4-bit (8-bit to 4-bit compression).
  The remaining 2 bytes are reserved for identifier string.

  Whilst in extended compression, there is no compression, in fact, the
  code with the least occurrence is translated to local code and stored,
  and prefixed with an extended identifer (8-bit to 5-bit truncation).

  This bit compression is far more efficient than 5-bit or 6-bit compression.
  However, this compression algorithm is only applicable to the predefined
  text file only.


  E-mail:  bookm@tm.net.my
  URL   :  http://www.geocities.com/SiliconValley/Horizon/3409/
}

const
  PrimaryTable:array [0..15] of char=('X','X',Chr(32),Chr(13),'f','l','a','n','t','s',
                                      'r','e','h','o','i','p');
  ExtendedTable:array [0..21] of char=('P','T','N','?','O','Y','I','q','B','-',
                                       ',','v','g','c','u','d','.','k','w','S','m','y');

  TemplateFileName='TEMPLATE.COM';
  RunFileName='RUN.COM';
  TextFileName='TEXT.TXT';
  TempFileName='TEMP';

var
  TemplateFile,RunFile,TextFile,TempFile:file;
  Buffer:array [1..2048] of byte;
  Size:word;
  Index:word;

  Found:boolean;
  Count:byte;
  Code:byte;
  Round:byte;
  ExtendedCode:byte;
  ExtendedID:boolean;
  Access,Top:boolean;
  ID:byte;

begin
  WriteLn('Template-to-Run COM File Generator');
  WriteLn('Developed by Boo Khan Ming');
  WriteLn;

  {$I-}
  Assign(TemplateFile,TemplateFileName);
  Reset(TemplateFile,1);
  Assign(RunFile,RunFileName);
  Rewrite(RunFile,1);
  Assign(TextFile,TextFileName);
  Reset(TextFile,1);
  Assign(TempFile,TempFileName);
  Rewrite(TempFile,1);
  {$I+}
  if IOResult<>0 then
  begin
    WriteLn('Unable to perform disk I/O operation.');
    Halt(1);
  end;

  { copy template program codes }
  BlockRead(TemplateFile,Buffer,SizeOf(Buffer),Size);
  BlockWrite(RunFile,Buffer,Size);

  { read entire text file }
  BlockRead(TextFile,Buffer,SizeOf(Buffer),Size);

  { initialize buffer pointer }
  Index:=0;
  Round:=1;
  Code:=0;
  ExtendedID:=False;
  Found:=False;
  Access:=False;
  Top:=False;

  repeat
    Inc(Index);

    if Buffer[Index]=10 then
      Inc(Index);

    for Count:=2 to 15 do
      if Buffer[Index]=Ord(PrimaryTable[Count]) then
      begin
        Found:=True;

        if (Top) or (Access) then
        begin
          Code:=Code or Count;
          Access:=True;
        end
        else
        begin
          Code:=Count shl 4;
          Top:=True;
        end;

        Break;
      end;

    if not Found then
      for Count:=0 to 21 do
        if Buffer[Index]=Ord(ExtendedTable[Count]) then
        begin
          if (Top) or (Access) then
          begin
            if Count>15 then
              Code:=Code or $01
            else
              Code:=Code and $f0;

            ExtendedCode:=Count shl 4;

            ExtendedID:=True;
            Access:=True;
          end
          else
          begin
            if Count>15 then
              Code:=$10 or (Count and $0f)
            else
              Code:=Count and $0f;

            Access:=True;
            Top:=False;
          end;

          Break;
        end;

    Found:=False;

    if Access then
    begin
      BlockWrite(TempFile,Code,1);
      Access:=False;
      Top:=False;
    end;

    if Index>Size then
    begin
      if Top then
      begin
        Code:=Code or $01;
        ExtendedCode:=$f0;
        BlockWrite(TempFile,Code,1);
        BlockWrite(TempFile,ExtendedCode,1);
      end
      else
      begin
        Code:=$1f;
        BlockWrite(TempFile,Code,1);
      end;
    end;

    if ExtendedID then
    begin
      Code:=ExtendedCode;
      ExtendedID:=False;
      Access:=True;
      Top:=False;
    end;
  until Index>Size;

  Reset(TempFile,1);
  BlockRead(TempFile,Buffer,SizeOf(Buffer),Size);
  BlockWrite(RunFile,Buffer,Size);

  Close(TempFile);
  Close(TemplateFile);
  Close(RunFile);
  Close(TextFile);

  Erase(TempFile);

  WriteLn('File generated successfully - ',RunFileName);
end.