    ; Pong clone by Roland Neul
    ; Assemble with: nasm -f bin -o entry.com entry.asm

    ; Last Changed: 27.07.98
    ; 228 Byte
    ; ASSUMES AH=0, CH=0, BX=0
    org 0100h

    ; Constants
addbar1  EQU 0068h
addbar2  EQU 006Ah

    ; Preparation [13]
    ; SI=bar1.x, BX=bar2.x, BP=ballpos
    ; - Initialize Screen mode 3
    mov al,03h                              ; 2
    int 10h                                 ; 2
    ; - Set segreg
    push WORD 0B800h                        ; 3
    pop es                                  ; 1
    ; - Initialize Variables
    xor si,si                               ; 2
    mov bp,0144h                            ; 3

    ; Main loop [181]
    ; - Drawing (53)
    ; - Assumes AH=0
mloop:
    ; -- Delete old bars / Print new bars
    mov di,si                               ; 2
    mov cl,0Ah                              ; 2
    rep stosw                               ; 2
    mov di,0F00h                            ; 3
    add di,bx                               ; 2
    mov cl,0Ah                              ; 2
    rep stosw                               ; 2
    mov di,bp                               ; 2
    or ah,ah                                ; 2
    jne .nomov                              ; 2
    ; -- Delete old ball
    stosw                                   ; 1
    ; -- Move ball
    add bp,[deltaX]                         ; 4
    add bp,[deltaY]                         ; 4
    ; -- Move bars
    add si,[addbar1]                        ; 4
    add bx,[addbar2]                        ; 4
    mov ax,0ADBh                            ; 3
    jmp SHORT mloop                         ; 2
.nomov:
    ; -- Print ball
    mov ax,09DCh                            ; 3
    stosw                                   ; 1
    ; -- Bars were moved
    mov di,addbar1                          ; 3
    mov [di],ecx                            ; 3

    ; - Delay (18)
delay:
    mov ah,01h                              ; 2
    mov cl,0Ah                              ; 2
    mov dx,03DAh                            ; 3
.loop1:
    in al,dx                                ; 1
    test al,08h                             ; 2
.loop2:
    jne .loop1                              ; 2
    xor [.loop2],ah                         ; 4
    loop .loop1                             ; 2

    ; - Keyboard handling (53)
    ; - Assumes: AH=1, DX=03DAh, DI=addbar1
getkey:
    ; -- Check for keypress
    int 16h                                 ; 2
    jz checkcol                             ; 2
    ; -- Clear Keyboard buffer
    mov ah,00h                              ; 2
    int 16h                                 ; 2
    mov al,0Ah                              ; 2
    ; -- correct scancode for normal num
    cmp ah,al                               ; 3
    ja .notlo                               ; 2
    xor ah,dl                               ; 2
.notlo:
    ; -- evaluate
    and ah,dh                               ; 2
    jz .add2                                ; 2
    dec ah                                  ; 2
    jz .add1                                ; 2
    neg al                                  ; 2
    dec ah                                  ; 2
    jz .add2                                ; 2
.add1:
    mov dx,si                               ; 2
    jmp SHORT .chkbar                       ; 2
.add2:
    mov dx,bx                               ; 2
    inc di                                  ; 1
    inc di                                  ; 1
.chkbar:
    ; -- Check if bar has reached border
    cbw                                     ; 1
    or ax,ax                                ; 2
    js .chklo                               ; 2
    sub dl,8Ch                              ; 3
.chklo:
    or dx,dx                                ; 2
    jnz .ok                                 ; 2
    xchg ax,dx                              ; 1
.ok:
    mov [di],ax                             ; 2

    ; - Check for collision (57)
checkcol:
    ; -- Get line, column
    mov ax,bp                               ; 2
    xor dx,dx                               ; 2
    push bx                                 ; 1
    mov bl,0A0h                             ; 2
    div bx                                  ; 2
    pop bx                                  ; 1
    ; -- test for collision with wall
    or dx,dx                                ; 2
    jz .negx                                ; 2
    cmp dl,9Eh                              ; 3
    jnz .tsty                               ; 2
.negx:
    neg WORD [deltaX]                       ; 4
.tsty:
    ; -- test if line is 0,1,23 or 24
    dec al                                  ; 2
    jz .tsthit                              ; 2
    js .istwo                               ; 2
    sub al,16h                              ; 2
    js .nonegy                              ; 2
    jnz exit                                ; 2
.tsthit:
    ; -- if it is 1 or 23,
    ; -- test if ball hit bar
    mov di,[deltaY]                         ; 4
    add di,bp                               ; 2
    mov al,0DBh                             ; 2
    scasb                                   ; 1
    jne .nonegy                             ; 2
    neg WORD [deltaY]                       ; 4
.nonegy:
    jmp mloop                               ; 3
.istwo:
    inc BYTE [winner]                       ; 4

    ; Cleanup [12]
    ; Assumes: AH=0
exit:
    ; - Initialize mode 3
    mov al,03h                              ; 2
    int 10h                                 ; 2
    ; - Print String
    mov dx,string                           ; 3
    mov ah,09h                              ; 2
    int 21h                                 ; 2
    ; - End program
    ret                                     ; 1

    ; Variables [22]
deltaX   dw 0002h
deltaY   dw 00A0h

string   db "Player "
winner   db "1 has won.$"

