; textmode pong, by Craig Davison (cdavison@cadvision.com)
; for hugi sizecompo #3
; still way too damn big.

.model tiny

.286

PADDLE_CHAR equ 0a00h + 219
BALL_CHAR equ 0900h + 220
; DI is the screen offset of the ball
; BX is added to DI every movement
; CX is the position of the ball
; DX is the direction of the ball
; p1, p2 are the paddle offsets
; oldp1, oldp2 are the 'old' paddle offsets

.code
org 0100h

code_start:
; set video mode
mov     ax, 0003h
int     10h

; initial stuff
push    0b800h
pop     es
mov     bx, 162-2
mov     dx, 0101h       ; +1, +1
mov     cx, 0202h       ; 02, 02
mov     di, 324         ; 02, 02

main_loop:
pusha

; === wait 5 vertical retraces. this is likely when input will be gathered by
; the keyboard buffer. ===
mov     cx, 5
retr_loop:
mov     dx, 03dah
retr0:
in      al, dx
test    al, 8               ; bit #3
jnz     short retr0
retr1:
in      al, dx
test    al, 8            ; bit #3
jz      short retr1
loop    short retr_loop

; === draw stuff ===
; clear paddles
lea     bx, [oldp1]
call    update_paddle
lea     bx, [oldp2]
call    update_paddle
popa

; clear ball
sub     di, 2
xor     ax, ax
stosw

; draw ball
compare_x:
mov     al, 2
mov     si, 4

add     ch, dh
or      ch, ch
jz      short checkx1
neg     al
neg     si
cmp     ch, 80
jne     short compare_y

checkx1:
neg     dh
add     ch, al                 ; new position
add     bx, si              ; adjust offset

compare_y:
or      cl, cl
jz      short checky1                ; player 2 wins
cmp     cl, 24
jne     short checky2                   ; game on
; player 1 wins
dec     [win_msg+7]

checky1:
jmp     short done

checky2:
add     cl, dl
cmp     word ptr es:[di+bx], PADDLE_CHAR
jne     short draw_ball

mov     si, 320
mov     al, 2
neg     dl                     ; flip direction
jg      short checky3
neg     al
neg     si
checky3:
add     cl, al                  ; new position
add     bx, si             ; adjust offset

draw_ball:
add     di, bx
mov     ax, BALL_CHAR
stosw

; === get input. keyboard buffer is cleared here. ===
get_input:
mov     ah, 01h
int     16h
jz      short main_loop
cbw                             ; clear ah
int     16h
mov     al, ah

lea     si, [p1]
cmp     al, 05h                   ; '4'
je      short in1a
cmp     al, 4bh                   ; left
jne     short in1
in1a:
cmp     word ptr [si], 0
je      short get_input
sub     word ptr [si], 10
in1:
cmp     al, 07h                   ; '6'
je      short in2a
cmp     al, 4dh                   ; right
jne     short in2
in2a:
cmp     word ptr [si], 140
je      short get_input
add     word ptr [si], 10
in2:
lea     si, [p2]
cmp     al, 1eh                 ; 'a'
jne     short in3
cmp     word ptr [si], 160*24
je      short get_input
sub     word ptr [si], 10
in3:
cmp     al, 20h                 ; 'd'
jne     short get_input
cmp     word ptr [si], 160*24+140
je      short get_input
add     word ptr [si], 10

jmp     short get_input

done:
mov     al, 03h               ; ah is 0 here
int     10h

mov     ah, 09h                 ; print win msg
lea     dx, [win_msg]
int     21h

ret                             ; exit to DOS

update_paddle:
xor     ax, ax
mov     cx, 10
mov     di, [bx]
rep     stosw
mov     di, [bx-4]      ; new position
mov     [bx], di
mov     ax, PADDLE_CHAR
mov     cx, 10
rep     stosw
ret

win_msg db "Player 2 has won.$"         ; dec [win_msg+7] if player 1 wins
p1 dw 0
p2 dw 160*24
oldp1 dw ?              ; doesn't matter where in the segment we blank
oldp2 dw ?              ; on the first refresh.

end code_start
