; Take 4 by IOPL (mail: iopl3@iname.com, surf: http://iopl.home.ml.org/).
;
; Known problems:
;
; - Assumes ax = bx = ch = 0x00, si = 0x0100, and that int 0x10 doesn't destroy
;   registers.
;
; Change log:
;
; Take 4 (197 bytes).
; - [YIPPEE!!! Finally managed to get below 200 bytes. Time to celebrate...]
; - In `key_right', replaced the jump to `looper' with a single `db 0xb8',
;   saving 1 byte. This was the optimization that allowed the program to break
;   through the 200-byte barrier.
; - OK, I confess... I just did something that's not very elegant: I actually
;   turned off the keyboard IRQ using `cli'! 3 bytes shorter than the good old
;   `mov ah,0x0c'/`int 0x21' sequence. At first I expected my last keystroke to
;   pop up after the program finished (it should still be stuck in the
;   keyboard controller buffer, even if it doesn't get to the buffer in main
;   memory), but -- surprise, surprise -- that didn't happen. Any idea why? I
;   tested this under a few different environments and gave it various inputs
;   (including the degenerate case of a single keystroke, which shouldn't fill
;   the keyboard controller buffer), and the results were consistent.
; - Shortened the dispatcher even further (at the price of even more invalid
;   keystrokes being accepted). Also merged the differentiation between `4'/`6'
;   and `left'/`right' together, saving 2 bytes.
; - Made `draw_bars' smaller by using a simple `recursion' trick (`call .0').
;   :)
; - Shifted the player number assignment out of `win_1' and `win_2' (now `win')
;   and put it inside the main loop, allowing for `dec ax'. 2 bytes saved.
;
; Take 3 (214 bytes).
; - Rewrote the keystroke dispatcher to do 1-by-1 comparisons instead of table
;   searches. It's actually shorter! However, now the program also accepts
;   some invalid keystrokes (although it won't die as a result)...
; - Also for the dispatcher: instead of using di, now the code uses cx to hold
;   the value 5 to add/subtract, thus allowing for `mov cl,5'. 1 byte saved.
; - Re-organized the horizontal and vertical bouncing code slightly. 2 bytes
;   saved.
; - Changed `xchg ax,[es:di]' in the vertical bouncing code to `stosw' (hmm...
;   why didn't I think of that before?), saving 2 bytes.
;
; Take 2 (226 bytes).
; - Re-structured the code for bouncing vertically, so that it uses the screen
;   buffer itself to check for collisions -- range checking sure takes up a lot
;   of space! (In the process, I also discovered a subtle bug in Take 1: the
;   bouncing occurs earlier than it should, at y == 2 / y == 22 instead of
;   y == 1 / y == 23. Well, it doesn't matter now.)
; - Discovered that doing the keystroke lookup manually is actually 1 byte
;   shorter than `repnz scasb'! (In order to use `repnz scasb', I had to
;   surround it with `push es'/`push ds'/`pop es' and `pop es'.)
; - Moved the `win_1'/`win_2' block out of the main loop so that jumps can be
;   made shorter.
; - Merged several lines of code together in the keystroke handlers, as well as
;   some other places.
; - The keyboard buffer is now cleared at the beginning of each iteration.
;
; Take 1 (260 bytes).
; - Initial attempt. Able to handle degenerate cases of the ball grazing a
;   paddle. Because invalid keystrokes are filtered out, it works even without
;   `run.bat' (!). [Afternote: Although it was still rejected because I didn't
;   clear the keyboard buffer at _each_ iteration, but only when the program
;   ends.]

	org	0x0100

start:	mov	al,0x03 		; Set screen mode
	int	0x10
	push	word 0xb800		; Set es to 0xb800
	pop	es
	cwd				; dx = bar1.x
	xor	bp,bp			; bp = bar2.x
	inc	si			; si = (dir.y / dir.x)
	mov	bx,si			; bx = (ball.y / ball.x)
	cli
looper: mov	ax,0x0adb
	call	draw_bars		; Draw bars
	mov	al,'2'
	add	bx,si			; Move ball:
	js	win			;   ball.y < 0, player 2 wins
	dec	ax
	cmp	bh,24
	ja	win			;   ball.y > 24, player 1 wins
	cmp	bl,80			;   If ball.x < 0 or >= 80, bounce
	jb	try_drawing_ball	;   horizontally (note that since x < 0
	mov	ax,0x01fe		;   means (unsigned char)x >= 80, the 2
bounce:	sub	bx,si			;   conditions can actually be tested
	xor	si,ax			;   together :)
	add	bx,si
try_drawing_ball:
	mov	ax,0x09dc		;   Draw ball (at long last)
	call	draw_ball
	jnz	ball_ok			;   Oops! Ball collided with bar...
	stosw				;   bounce vertically
	mov	ax,0xfe00
	jmp	short bounce
ball_ok:
	mov	cl,5			; Delay
	push	dx
	mov	dx,0x03da
wait_1: in	al,dx
	test	al,8
	jz	wait_1
wait_2: in	al,dx
	and	al,8
	jnz	wait_2
	loop	wait_1
	pop	dx
					; If ball was drawn correctly, then
					; ah will be 0x07 from the last
					; `xchg ax,[es:di]' in `draw_ball', and
					; al will be 0x00 from the last
					; `and al,8'
	call	draw_bars		; Erase bars
	call	draw_ball		; Erase ball
	mov	cl,5
	in	al,0x60 		; Get keystroke
	cmp	al,0x07
	jna	key_left_right
	cmp	al,0x20
	jz	key_d
	jb	key_a
	cmp	al,0x4d
	ja	looper
key_left_right:
	jnb	key_right
key_left:
	sub	dx,cx
	jns	looper
key_right:
	add	dx,cx
	cmp	dl,70
	ja	short key_left
	db	0xb8
key_d:	add	bp,cx
	cmp	bp,byte 70
	jna	looper
key_a:	sub	bp,cx
	jns	looper
	jmp	short key_d

win:	mov	[winner],al		; Winner has been decided!
	mov	ax,0x0003		; Reset screen mode
	int	0x10
	mov	ah,0x09 		; Display banner
	mov	dx,msg
	int	0x21
	ret				; Get out of here

draw_bars:
	mov	di,dx
	call	.0
	lea	di,[80*24+bp]
.0:	shl	di,1
	mov	cl,10
rep	stosw
	ret

draw_ball:
	mov	cl,bh
	imul	di,cx,80-256
	add	di,bx
	shl	di,1
	xchg	ax,[es:di]
	cmp	al,0xdb
	ret

msg:		db	"Player "
winner: 	db	"? has won.$"
