
.Model TiNY
.586

.CODE
 ORG 100h
PROGRAM_STARTS_HERE:

        ADD   [BX], CL   ; same as MOV Word Ptr[SI], 0F00h, but 2 bytes smaller

        POP   SP

        MOV   SI, 100h     ; Remove this if not using debuggers            (-3)

        PUSH  0B800h
        POP   ES

        MOV   BL, 0A0h   ; Y direction
        MOV   DI, 0A2h   ; ball's X,Y             WASTE WASTE WASTE WASTE
        PUSH  78         ; Countdown to collision


        MOV   AL, 03h    ; Set video mode 3h and mask keyboard interrupts
        OUT   21h, AL
        INT   10h

	; { MAIN LOOP

MAINLOOP:

        MOV   CL, 0Ah
        MOV   DX, 3DAh
      DELAY:
        IN    AL, DX
        XOR   AL, BL
        TEST  AL, 08h
        JE    DELAY
        NOT   BL
        LOOP  DELAY

        XCHG  AX, CX         ; Remove Ball from Screen
        CLD
        STOSW

                             ; Move ball and check events
        CMP   ES:[BX+DI],DL  ; READ UNDERLYING CHAR   ( DL = 0DAh )
        JNA   BarNotHit
        NEG   BX
			BarNotHit:
        STOSW
        ADD   DI, BX

        CMP   DI, 25*160
				JNA 	NothingExpecial

			;GameOver:
        MOV   AL, 03h       ; Re-init mode 3h
        SUB   byte ptr [SI+(offset WINPLYR - 100h)], BH
				INT 	10h
				Mov 	dx, offset Results
				MOV 	AX, 09B8h 			; Write results
				OUT 	21h, AL 				; Restore PIC status
				INT 	21h
        INT   20h             ; Quit

NothingExpecial:
        POP   CX              ; Userful Counter (.... :-| ....)
        LOOP  NoXCollision
      XCollision:
        XOR   SP, 4
        MOV   CL, 79
			NoXCollision:
        SUB   DI, SP
        PUSH  CX
        PUSH  DI
        CALL  CLEAR_BARS

        IN    AL, 60h
				TEST	AL,0B0h
				JS		SHORT NO_KEY_WAS_HIT

        PUSH  SI
        MOV   DX, 8C0Ah

        JNZ   Letter
        DEC   SI
        DEC   SI
			Letter:
				AAM
				AND 	AL, 2
				JNZ 	MoveLeft
      UNDO:
        NEG   DL
      MoveLeft:
        ADD   [SI], DL
        CMP   [SI], DH
				JA		UNDO

        POP   SI

			NO_KEY_WAS_HIT:

        CALL  UPDATE_BARS

        MOV   AX, 09DCh      ; Draw Ball
        POP   DI
        STD
        STOSW
        JMP   short MainLoop

	; }

    Results db 'Player '
    WinPlyr db '1 has won.$'

		UPDATE_BARS:
        MOV   AX, 0ADBh      ; Draw Bar1
    CLEAR_BARS:
        MOV   DI, [SI]
        CALL  VRAIT          ; WRITE
        MOV   DI, [SI-2]
                             ; Draw Bar2
    VRAIT:
        MOV   CL, 10
        REP   STOSW
        RET


END PROGRAM_STARTS_HERE
