.model tiny
.586

.CODE
	ORG 100h
PROGRAM_STARTS_HERE:

  MOV   AL, 03h    ; Set video mode 3h
  INT   10h

;  MOV   BP, 0202h
;  XOR   SI, SI
;  MOV   DI, 1800h

  MOV   BP, Offset BallCoord


	; { MAIN LOOP

MAINLOOP:

    MOV   BL, 0Ah
    PUSH  OFFSET GO_QUI

  UPDATE_BARS:
    MOV   AX, 09DBh      ; Draw Bar1
    MOV   DX, [BP+2]
    MOV   CL, 10
    CALL  IO_FUNC        ; WRITE

    MOV   DX, [BP+4]     ; Draw Bar2

IO_FUNC:
    PUSHA
    MOV   AH, 2          ; Locate cursor
    INT   10h
    POPA
    INT   10h            ; read / write
    RET

  GO_QUI:

    INC   AX
    MOV   DX, [BP]       ; Draw Ball
    DEC   BX
    MOV   CL, 1
    CALL  IO_FUNC

  PUSHA
    MOV   CL, 0Ah
    MOV   DX, 3DAh
    DEC   BX             ; = 8
  DELAY:
    IN    AL, DX
    XOR   AL, BL
    TEST  AL, 08h
    JE    DELAY
    NOT   BL
    LOOP  DELAY
  POPA

    MOV   AL, 00         ; Remove Ball from Screen
    CALL  IO_FUNC



        XCHG  AX, DX         ; Move ball and check events

smc1:   INC   AH
smr1:   INC   AL

        CMP   AL, 50h        ; == 80d
        JB    NoXCollision
smr2:   SUB   AL, 2

        XOR   byte ptr [BP+SMR1-BALLCOORD+1], 08h
        XOR   byte ptr [BP+SMR2-BALLCOORD  ], 28h

      NoXCollision:
        XCHG  AX, DX
        MOV   AH, 8
        CALL  IO_FUNC        ; READ UNDERLYING CHAR

        CMP   AH, 0Ah
        JNE   BarNotHit
smc2:   SUB   DH, 2
        XOR   byte ptr [BP+SMC1-BALLCOORD+1], 08h
        XOR   byte ptr [BP+SMC2-BALLCOORD+1], 28h
      BarNotHit:

        CMP   DH, 24
        JNA   NothingExpecial

GameOver:
        MOV   AX, 0003h       ; Re-init mode 3h
        ADD   DH, AL
        ADC   byte ptr [BP+WINPLYR-BALLCOORD], -1
        INT   10h
        Mov   dx, offset Results
        mov   ah, 9           ; Write results
        int   21h
        RET                   ; quit

NothingExpecial:
        MOV   [BP], DX

        XOR   BX, BX
        CALL  UPDATE_BARS


    MOV   AH, 01
    INT   16h         ; KeyPressed?
    JZ    NO_KEY_WAS_HIT
		SUB 	AX, AX
		INT 	16h 				; Go for it!
    MOV   AL, AH      ; Duh...

		PUSHA

    MOV   BX, 0705h   ; '6' and '4'
    LEA   SI, Bar1Pos
		CALL	CheckThem

    MOV   BX, 4d4bh   ; '<-' and '->'
    CALL  CheckThem   ;

    MOV   BX, 201eh   ; 'd' and 'a'
    INC   SI
    INC   SI
    CALL  CheckThem

		POPA


	NO_KEY_WAS_HIT:

    JMP   MAINLOOP

  ; }

CheckThem:
		CMP 	AL, BL			; Move left?
		JNE 	CheckAnother
    CMP   Byte Ptr [SI], 0
		JZ		DontMove
    SUB   Byte Ptr [SI], 5
		RET

CheckAnother:
		CMP 	AL, BH			; Move right?
		JNE 	DontMove
    CMP   Byte Ptr [SI], 70
		JE		DontMove
    ADD   Byte Ptr [SI], 5

DontMove:
		RET
 
  BallCoord dw 0202h         ;  2x,  2y
  Bar1Pos   dw 0000h
  Bar2Pos   dw 1800h

	Results db 'Player '
	WinPlyr db '2 has won.$'

END PROGRAM_STARTS_HERE
