.Model TiNY
.586

.CODE
 ORG 100h
PROGRAM_STARTS_HERE:

        ADD   [BX], CL   ; same as MOV Word Ptr[SI], 0F00h, but 2 bytes smaller

;        MOV   SI, 0100h  ; Uncomment this iff using debuggers              (-3)

        PUSH  0B800h
        POP   ES

        MOV   AL, 03h    ; Set video mode 3h and mask keyboard interrupts
        OUT   21h, AL
        INT   10h

;        PUSHA            ;
;          MOV   AH, 0Bh  ;
;          MOV   BX, 1    ; Uncomment this to check correct bounds
;          INT   10h      ;
;        POPA             ;

        MOV   BL,  0A0h  ; Y direction
        MOV   DI, 0142h  ; ball's X,Y             WASTE SPACE, WASTE SPACE!
        MOV   DX, 3DAh   ; VGA status I/O register
        MOV   CL, 79     ; Countdown to doomsd... oops to colision           :)

  ; { MAIN LOOP          (AX=0003)

MAINLOOP:
        LOOP  NoXCollision
        NEG   SP
        MOV   CL, 79
			NoXCollision:
        SUB   DI, SP
        MOV   word ptr ES:[DI], 09DCh ; Draw Ball

        PUSHA                ; Saves AX, CX and DI
        CALL  UPDATE_BARS    ; Remove bars

        IN    AL, 60h
				TEST	AL,0B0h
				JS		SHORT NO_KEY_WAS_HIT
        PUSH  SI
        MOV   CL, 0Ah
        JNZ   Letter
        DEC   SI             ; Choose the other bar
        DEC   SI
			Letter:
        AAM                  ; This works also for uppercase letters (duh..)
        AND   AL, 2          ; Can someone tell me a smaller way?
				JNZ 	MoveLeft
      UNDO:
        NEG   CL
      MoveLeft:
        ADD   [SI], CL       ; Using an array for bars eats less codespace (!!!)
        CMP   byte ptr [SI],08Ch ; if < 0 || > 140 then we're out of borders
        JA    UNDO

        POP   SI
			NO_KEY_WAS_HIT:
        MOV   AX, 0ADBh      ; Draw Bars in rule's color
        CALL  UPDATE_BARS

        MOV   CL, 0Ah        ; Yeah, I MUST init CX twice... :-(
      DELAY:
        IN    AL, DX         ; too bad I can't shrink it more... :-?
        XOR   AL, BL
        TEST  AL, 08h
        JE    DELAY
        NOT   BL
        LOOP  DELAY          ; outcoming BX is same as incoming. (useless)

        POPA
                             ; Move ball and check events
        CMP   ES:[BX+DI],AH  ; Examine underlying char   ( AH = 00 )
        JNL   BarNotHit      ; - only BAR's and BALL's character are signed
        NEG   BX             ; flip Y direction as written in rules
			BarNotHit:
        STOSW                ; Remove Ball from Screen
        LEA   DI, [DI+BX-2]

        CMP   DI, 25*160
        JNA   Short MainLoop

			;GameOver:
        SUB   byte ptr [SI+(offset WINPLYR - 100h)], BH ; Set winning player
        INT   10h            ; Re-init mode 3h ( AX == 0003 for all the time )
        MOV   AX, 09B8h      ; Write results
        OUT   21h, AL        ; Restore PIC status
        MOV   DX, offset Results
        INT   21h            ; Display message
        INT   20h            ; Quit... 1 byte wasted but since SP is lost
                             ; (and CD 20 is changed into CB 20) I must :-/

	; }

    Results db 'Player '     ; Argh... I want this to be bound the first 128
    WinPlyr db '1 has won.$' ; bytes (so that I can save 1 byte in addresses)

    UPDATE_BARS:
        MOV   DI, [SI]       ; Lower bar
        CALL  VRAIT          ; WRITE!
        MOV   DI, [SI-2]     ; Upper bar

    VRAIT:
        MOV   CL, 10         ; Pretty straightforward, pretty space-eating :-/
        REP   STOSW
        RET

END PROGRAM_STARTS_HERE
