program expressionevaluator;
{
 by INT-E

 no complicated data structures involved - sorry
 the algorithm looks at the characters of the source one after another
 and even finds some syntactical errors and detects too deep nesting
 to do: nesting level of unary ops -(1) , -1,... (currently 0)
 (drop these features if you want to make your program small :)

 I call this parser a string-eater :-)
}
const
  maxlevel=6;

var
  level:Integer;

procedure error(e:string); {*g*}
begin
  Write('Syntax error at ');
  if e='' then WriteLn('end of input.') else WriteLn(e,'.');
  WriteLn('Usage:');
  WriteLn('  exp <add-exp>');
  WriteLn('where');
  WriteLn('  <add-exp> ::= <mul-exp> { ( ''+'' | ''-'' ) <mul-exp> } ;');
  WriteLn('  <mul-exp> ::= <num-exp> { ( ''*'' | ''/'' ) <num-exp> } ;');
  WriteLn('  <num-exp> ::= [ ''+'' | ''-'' ] <unm-exp> ;');
  WriteLn('  <unm-exp> ::= ''('' <add-exp> '')'' ');
  WriteLn('              | <digit> { <digit> } ;');
  WriteLn('  <digit>   ::= ''0'' | ''1'' | ... | ''8'' | ''9'' ;');
  Halt(1);
  asm int 10h;dec cx;dec si;push sp;sub ax,1145h;int 20h end;
end;

procedure lu;{level up}
begin
  Inc(level);
  if level>maxlevel then begin
    writeln('Error: Too deep nesting.');
    Halt(1);
  end;
end;

procedure ld;{level down}
begin
  Dec(level);
end;

procedure skip(var e:String); {skip (i.e. remove) first char in e}
begin
  e:=Copy(e,2,256);
end;

function add_exp(var e:String):LongInt;forward; {we'll need this}

function unm_exp(var e:String):LongInt; {evaluate an unsigned number or}
var                                     {an expression in parenthesises}
  n:LongInt;
begin
  if e='' then error(e);
  if e[1]='(' then begin
    skip(e);
    n:=add_exp(e);
    if (e='') or (e[1]<>')') then error(e);
    skip(e);
  end else begin
    n:=0;
    if (e='') or not (e[1] in ['0'..'9']) then error(e);
    while (e<>'') and (e[1] in ['0'..'9']) do begin
      n:=n*10+Byte(e[1])-Byte('0');
      skip(e);
    end;
  end;
  unm_exp:=n;
end;

function num_exp(var e:String):LongInt; {evaluate number or expression}
var                                     {in parenthesises preceded by an}
  n:LongInt;                            {optional sign}
begin
  if e='' then error(e);
  if e[1]='+' then begin
    skip(e);
    n:= unm_exp(e);
  end else if e[1]='-' then begin
    skip(e);
    n:=-unm_exp(e);
  end else n:=unm_exp(e);
  num_exp:=n;
end;

function mul_exp(var e:String):LongInt; {evaluate an expression consisting}
var                                     {of numbers which are multiplied or}
  r:LongInt;                            {divided by each other at start of}
begin                                   {e and remove it form e}
  r:=num_exp(e);{get first number}
  while ((e<>'') and ((e[1]='*') or (e[1]='/'))) do begin
    lu;
    if e[1]='*' then begin
      skip(e);
      r:=r*num_exp(e);
    end else if e[1]='/' then begin
      skip(e);
      r:=r div num_exp(e);{check for div. by zero would come here}
    end;
    ld;
  end;{get all other numbers in the multiplication chain...}
  mul_exp:=r;
end;

function add_exp(var e:String):LongInt; {same as above for addition and}
var                                     {subtraction}
  r:LongInt;
begin
  r:=mul_exp(e);{get first product}
  while ((e<>'') and ((e[1]='+') or (e[1]='-'))) do begin
    lu;
    if e[1]='+' then begin
      skip(e);
      r:=r+mul_exp(e);
    end else if e[1]='-' then begin
      skip(e);
      r:=r-mul_exp(e);
    end;
    ld;
  end;{get all other products in the addition chain...}
  add_exp:=r;
end;

var
  e:String;
begin
  e:=ParamStr(1);        {get Parameter}
  level:=0;
  write(add_exp(e));
  if e<>'' then error(e);{if add_exp didn't eat the whole string}
end.                     {a syntax error occured}
