        p486
        ideal

;; Expression evaluator:


;; assuming initial conditions:
;; AX=0 ; BX = 0; CX=00FF ; DX=CS < 8000h;
;; SP = FFFE ; SI=100 ; TopOfStack = 0 ; Direction Flag=0
;; (all true for a .COM file under DOS)

;; assuming about command-line input:
;; 1 argument (the expression) is supplied
;; The argument contains NO whitespaces and
;; ends with CR.
;; The argument forms 1 valid expression

;; use of whitespace, excessive )'s or other invalid
;; stuff causes the program to CRASH!!!

;; will crash if you have less than 128K of DOS memory...
;; or load this program HIGH

segment cseg use16
assume cs:cseg
assume ds:cseg


        org 100h
start:  add al,82h
        xchg si,ax  ;; SI <- 82h, AX <- 100h
        or al,[si+7Eh]  ;; AL <- 4
        xchg bx,ax  ;; BX <- 104h, AX <- 0
        xchg di,ax  ;; DI <- 0
        fldcw [word ptr bx+offset LUTy - 0FFh]

        ;; DX >= -1 to signal unary operand or start of number
N7:     lodsb
        sub al,30h
        mov [bx],di  ;; 0
        inc dx
        jb short N4   ;; jump out if non-digit        
        js short N72
        fldz
N72:    fimul [word ptr bx-1]  ;; 10d
        mov [bx],al
        fiadd [word ptr bx]
        cwd

;; if Operator ")" or End-Of-Line:        
N14:    add dx,sp
        js N7  ;; Will jump as long as SP < 0


;; Output the result:

        ;; just guesses that nothing important follows the command-
        ;; line arguments...
        fbstp [tbyte ptr si]
        mov cl,9
        push 24h      ;; push "$"

N50:    lodsb        
        dw 10D4h     ;; undocumented opcode  (a DIV imm8, exists on all x86's)
        or ax,3030h
        xchg al,ah
        push ax       ;; yup, build up the number on the stack (hehe)
        loop N50
        
        mov di,sp
        mov ax,930h
        mov cl,18
        repz scasb
        dec di
        ;; SCASB sets carry flag if any byte value > 30h

        ;; we shall set '-' if carry flag is SET
        ;; and [SI]=80h
        lodsb
        adc al,7Fh
        jnz short N51
        dec di
        mov [byte ptr di], 2Dh     ;; output "-" for numbers < 0 only
N51:    mov dx,di
        int 21h       ;; print string using function 09h (redirectable)
        int 20h


        ;; start processing of non-digit character
N4:     add al,8
        cbw
        jz short N12    ;; "("
        dec ax
        dec ax
        js short N42           ;; ")" or CR (counts as ")" )

        ;; DX >= 0 here indicates unary operand, DL < 0 indicates binary
        add dx,dx      ;; carry set if BINARY operand  
        sbb al,( 103h - offset LUTy)   
N4e:    xlat
        mov ah,30h
        rol ax,3        ;; AH <- priority of operand (signed value)
                        ;; AL <- second half of instruction used to
                        ;;  execute operand

;; if Operator "/*-+", unary or binary

;; pop operators off the stack and execute them as long as they
;; have higher priority than operand specified in AX register
N42:    pop dx
        cmp dh,ah
        mov [bx+ offset N45- 104h],dl ;; complete the instruction at N43a
        jle short N43a
N43:    sahf           ;; AH=0FFh indicates Operator ")" or End-Of-Line
        ;; AH in range 80-BF indicates regular operand
        ;; Bit 6 in AH corresponds to Zero Flag
        jz N14

        push dx      ;; push back latest entry popped from stack

;; if operator "("  (also end of operator "/*-+" routine)
N12:    cwd          ;; DX <-  -1 or 0
        push ax        ;; push operator onto stack
        jmp short N7

;; LUT entry :  ((2nd_half_of_instruction - 1)  >>  3)  |  ((priority + 8) << 5)
;;          *   bin+  un+  bin- un-  /
LUTy    db 79h, 098h, 24h, 9Dh, 05h, 7Fh

   
N43a:   db 0DEh ;; first half of instruction used to execute operand
N45     db ?
        frndint
        jmp short N42
        
ends

end start

;; old age comes to those who wait
