; Preliminary Expression-Evaluator entry by Shayde/Reality Sep '98 - 130 bytes
; For Hugi-Compo No 4.  To contact me: shayde@ihug.co.nz.  Country: New Zealand
;
; Assumptions on entry: AH=0, ECX(31-8)=0, CLD, FPU Stack empty
; Sets FPU Control Word to $0FDE (normally $037F)
;
; NOTE: Only runs on Win95/98/NT DOS, which is okay 'ccording to r00lz.

		.586
CODE16		SEGMENT PARA PUBLIC USE16
		ASSUME CS:CODE16, DS:CODE16
		ORG	100h

Start:		mov	si,82h			; command line past space
		mov	bx, offset EndCode	; temporary storage area
		mov	cl,10			; useful value
		fldcw	[bx-(EndCode-fcw)]	; put FPU into chop mode
		fldz
		call	Expr			; evaluate expression
		fistp	dword ptr [bx]		; convert float -> int

	; output sign of number
		cmp	[bx+3],ah		; is integer signed?
		jge	pc
		neg	dword ptr [bx]		; convert to positive
		mov	ah,6
		mov	dl,'-'
		int	21h			; output sign to console

	; create ASCII representation of result
	pc:	mov	eax,[bx]		; grab positive integer
		dec	bx			; move past '$'
	pa:	dec	bx
		xor	edx,edx			; XOR DX,DX doesn't work :(
		div	ecx
		add	dl,'0'
		mov	[bx],dl
		or	eax,eax			; finished converting?
		jnz	pa

	; output ASCII result
		mov	ah,9
		mov	dx,bx
		int	21h
	rr:	ret


; Mathematical operations
	; addition/subtraction
	ac:	faddp	st(1),st		; used for subtraction too
		jl	rr			; end of expression?
		dec	si			; read add/sub as a sign

	; multiplication/division
Expr:		call	ReadNumber		; read multiplicand/dividend
	mc:	jz	mb
	ma:	cmp	al,'*'-2fh
		jnz	ac

		call	ReadNumber		; read multiplier
		fmulp	st(1),st		; multiply
		jnz	ma			; no size advantage. still...

	mb:	call	ReadNumber		; read divisor
		fdivp	st(1),st		; divide
		frndint				; and chop fractional part
		jmp	mc


; Read signed number (and bracketed expression) from SI and return next
; character in AL.
ReadNumber:	fldz

	; parse sign of number
		lodsb
		cmp	al,'+'
		jz	nb
		cmp	al,'-'
		jnz	nc

	; negative number.  read it as positive then negate it
		call	nb
		fchs
		ret

	nd:	call	Expr

	; parse ASCII number into FPU register
	nb:	lodsb
	nc:	cmp	al,'('			; bracketed expression?
		jz	nd			; evaluate bracketed expr.

		sub	al,2fh			; is it a digit?
		jbe	rr			; no, end parsing
		mov	[bx],cx
	fcw:	fimul	word ptr [bx]		; multiply accumulator by 10
		dec	ax
		mov	[bx],ax
		fiadd	word ptr [bx]		; add digit to accumulator
		jmp	nb

		db	'$'
EndCode:
		ENDS
		END	Start
