.model tiny
.486
.code
Ideal
org 100h

;--------------------------------------
;Reg	Value	Why?	Purpose
;--------------------------------------
;ah	digit	aam
;al	digit 	lodsb	digit to display
;bl	flag	cmp bl	remove leading 0
;cx	cmpt	loop	loop on the result digits
;dl	char	int 21	ascii code to display
;si	addr	lodsb	bcd number to display

;--------------------------------------
;MAIN

start:  mov bl,82h			;2	si=begining of expression
	xchg bx,si			;2	bx=temporary variable=0100h
	fldcw [bx+(exit-start)]		;3	Set rounding to 'trunc'
	call expr			;3 10

exit:   std				;1	               } Used a data
	fbstp [si-8]			;3	Store as a BCD } for fldcw
	lodsw				;1
	sahf				;1	MSB is 00|80|FF
	jns ex3				;2	00 -> positive number
;	jnz ex1				;2	80 -> negative number
;	aam 00h				;2	FF- > NaN : generate div-by-0
ex1:	mov dl,'-'-'0'			;2	Display the '-' sign
	inc bx				;1 11	Used for leading zero
	
ex2:    call print			;3	Prints what is in dl
ex3:	lodsb				;1
	aam 10h				;2	Unpack BCD from al to ah/al
	mov dl,ah			;2
	push ax				;1
	call print			;3	Prints what was in ah
	pop dx				;1	Puts in dl what was in al
	loop ex2			;2	Do that 7 times (14 digits)
	dec bx				;1 16	Force last char to be displayed 

print:	cmp dl,bl			;2	Check if it's a leading 0
	je return			;2
	dec bx				;1	Force next char to be displayed
	add dl,'0'			;3	Convert to ascii value
	mov ah,02h			;2
	int 21h				;2 12

calc:	aam 0Eh				;2	See comments below, note 3
	aad 0A4h			;2	
return:	ret				;1 5


;--------------------------------------
;Reg	Value	Why?	Purpose
;--------------------------------------
;al	char 	lodsb	next char in expression
;bx	100h	[bx]	variable for communication with fpu
;dx	addr	mov dl	address of terme or fact
;dl	opcode	mov dl	second half of fpu opcode
;si	addr	lodsb	position in expression

;--------------------------------------
;PARSE EXPR [ + - * / ]

expr:   mov dx,offset terme		;3
	jmp op				;2

terme:  mov dl,offset fact-100h		;2 7	Here, dh is already ok

op:	push dx				;1
	call dx				;2	Call terme or fact
op1:	pop dx				;1
	mov cl,7			;2	Used in the exit routine
	jnp calc			;2 	See below, note 3
	inc ax				;1	Three instruction to calculate
	aam 54h				;2	 the fpu opcode C1|E9|C9|F9
	or al,0C1h			;2	 see below, note 4
	push dx				;1
	push ax				;1
	call dx				;2	Call terme or fact
	pop dx				;1 18

	mov [byte bx+(opcode-start)],dl	;3	Self modifying code
	faddp				;2
opcode  = byte $-1
	frndint				;2	Trunc for divisions (5/4=0)
	jmp op1				;2 9

;--------------------------------------
;PARSE FACT [ ( ) 0123456789 ]

	org $-1				;-1	Previous byte is  already 'E8'
rec:	call expr                       ;3	 which is the opcode of call
	jmp nb1				;2 4	Assume ')' and continue

fact:	lodsb				;1	Read next char
	cmp al,'('        	        ;2
	je rec				;2	Begin a new expression in ()
	fldz				;2	Loads zero in the FPU
	fist [dword bx]			;2 9	Stores some zeros in memory

nb:	sub al,'0'               	;2
	js calc				;2	Tests if it's a digit
	mov [byte bx],10		;3
	fimul [dword bx]		;2	Parse the number and put
	mov [byte bx],al		;2	 it into the fpu
	fiadd [dword bx]		;2	
nb1:	lodsb				;1	Read next char
	jmp nb				;2 16

	end start

;--------------------------------------
;SOME COMMENTS
;
;1. What's different with the FPU ?
;   The Control Word has to be initialized so that rounding mode is set to
;   trunc (so that 5/4=0) and exceptions like precision lost are masked.
;   The opcodes are two bytes, but only the second one differs between faddp,
;   fsubp, fmulp and fdivp : self-modifying code is easier.
;   Output can be done in BCD, with the first bit for the sign.
;   Operations have better precision, so no need to worry with -2147483648.
;   Most registers are free (division doesn't need 3 registers !)
;   No 66h prefix, no supposition on the initial value of eax,ebx...
;
;2. Division by zero
;   The division by zero generates a NaN in the fpu. It can be detected and
;   the program can output a "Divide overflow" message. Just uncomment the
;   two lines in 'exit' for that.
;   But since the rules say "If an overflow or underflow occurs, the program
;   cannot compute correctly.", no need to do that. Here it displays '-0'.
;
;3. The calc routine which checks for +|-|*|/ :
;   The only valid characters in an expressions are the digits, the '(' for
;   a sub-expression, the '+','-','*','/' for operations, and the three
;   terminating characters ')', ' ' (space), '\0x0D' (eof).
;   This routine uses aam & aad to set the parity flag. The first time it's
;   called, when exiting 'fact', parity is even only for '*' and '/'.
;   The second time, parity is even only for '+' and '-'.
;   If it's still odd, we know it's a ')', a ' ', or a '\0x0D'.
;
;4. The op routine which calculates the opcode of the fpu operation :
;   In 'ax' there is the result of the calc function (aam & aad), called
;   once for * and /, or twice for + and -.
;   Then, with these three instructions (inc, aam, or) in calculates the
;   opcode of the corresponding fpu operation.
