;*********************************************************************
;                    ---=== SMALL SORT ===---
;*********************************************************************
; AUTHOR        : Darkblade - TZT (Tribe 2 Tribe)
; DATE          : 02/11/98
;*********************************************************************
; INFORMATION   : This relies on a few intial registers
;                 ax = 0000
;                 cx = 00FF
;                 bp = 0900 (or there abouts)
;*********************************************************************
; HISTORY       : 02/11/98  - First Version 126 bytes
;               : 02/11/98  - Removed the need for 0 termination
;               : 03/11/98  - Removed the seperate check/read input
;               : 03/11/98  - Rewrote string sort
;               : 03/11/98  - Altered pointer system
;               : 03/11/98  - Fixed bug that meant single line files
;                             would not sort properly
;               : 03/11/98  - Fixed bug that meant no input will exit
;               : 03/11/98  - Altered the exchange function
;               : 03/11/98  - Altered the add ??,2 to inc ?? inc ??
;               : 03/11/98  - Added the xchg for the print routine
;               : 03/11/98  - Altered clearing of cx
;               : 03/11/98  - Altered the setting of the Buffer
;               : 03/11/98  - Added xchg ax, dx to set dl to 0xff
;               : 06/11/98  - Added lodsw to increase string pointer
;               : 06/11/98  - Added stosw to increase string pointer
;               : 08/11/98  - Removed redundent 0Ah check
;*********************************************************************

                        .model  TINY
                        .586
    
                        .code

                        ORG  100h

;*********************************************************************
; First thing we need to do is to read a string in
;*********************************************************************
Start:                  mov     di, bp                              ;2
                        lea     si, Pointers                        ;3
                        push    si                                  ;1
                        xchg    ax, cx                              ;1
                        xchg    ax, dx                              ;1

ReadBuffer:             ; Store the offset to this string
                        mov     WORD PTR [si], di                   ;2
                        lodsw                                       ;1

                        ; Read the string
ReadString:             mov     ah, 06h                             ;2
                        int     21h                                 ;2
                        jz      Exit                                ;2
                        stosb                                       ;1
                        sub     al, 0ah                             ;2
                        jnz     ReadString                          ;2

                        ; Increase the number of strings
                        inc     cx
                                                                    ;1
                        ; Get all the lines
                        jmp     ReadBuffer                          ;2
Exit:                                                             ;----
                                                                    ;26

;*********************************************************************
; We now need to order the strings
;*********************************************************************

OrderStrings:           pop     bx                                  ;1
                        push    bx                                  ;1
                        mov     dx, cx                              ;2
                        
Order:                  dec     dx                                  ;1
                        jle     FinishedSort                        ;2
                        mov     si, [bx]                            ;2
                        inc     bx                                  ;1
                        inc     bx                                  ;1
                        mov     di, [bx]                            ;2

CPString:               cmpsb                                       ;1
                        je      CPString                            ;2
                        jc      Order                               ;2
                        ror     DWORD PTR [bx - 2], 16              ;5
                        jmp     OrderStrings                        ;2
FinishedSort:
                                                                   ;----
                                                                    ;30
;*********************************************************************
; Print the ordered strings
;*********************************************************************

                        pop     di                                  ;1
PrintBuffer:            mov     si, [di]                            ;2
                        stosw                                       ;1
PrintString:            lodsb                                       ;1
                        xchg    dx, ax                              ;1
                        mov     ah, 02h                             ;2
                        int     21h                                 ;2
                        cmp     al, 0ah                             ;2
                        jne     PrintString                         ;2

                        loop    PrintBuffer                         ;2
                                                                  ;----
                                                                    ;17
;*********************************************************************
; Exit the program
;*********************************************************************
                        ret                                         ;1

;*********************************************************************
; Variables
;*********************************************************************
                        db      0800h DUP (?)   ; Space for di,bp
Buffer:                 db      30000 DUP (?)
Pointers:               dw      15000 DUP (?)

                        END Start
