; Neon/Spetsnaz' entry for Hugi Size Coding Compo #5 (sorter)
; Current size: 65 bytes
;
; compile with tasm /m2 neon.asm
; tlink with tlink /t neon.obj
;
; Loads the file to ds:bp
; 00h is stored at the end
; 01h is stored at the beginning of each line when it has been printed (actually all characters
; except the 0Ah is set to 01h)

                .586
                Ideal
                Model   Tiny
                CodeSeg
                StartupCode
; Read from stdin
                mov     di,bp
                mov     ah,06h
                mov     dx,cx
@@ReadLoop:
                int     21h
                stosb
                jnz     @@ReadLoop
@@Done:
; Setup register
                inc     bx
; Sort
@@StartSort:
                mov     di,bp                   ; reset pointers
                mov     si,di
@@CheckLine:
                cmp     [di],ch                 ; check if this is eof
                jz      @@Exit                  ; quit if it is
                cmp     [byte di],0Ah           ; check if it's eol
                ja      @@Continue
                inc     di
                jmp     @@CheckLine
@@Continue:
@@SortLoop1:                                    ; di is current smallest string
@@NextLineLoop:
                lodsb
                cmp     al,0Ah
                jne     @@NextLineLoop

                cmp     [si],bl                 ; check the line
                jb      @@PrintString           ; end of file, print string in di
                je      @@NextLineLoop          ; string is already sorted/printed
                                                ; di points to next string
                pusha
                repe cmpsb                      ; compare strings
                popa
                jnb     @@SortLoop1             ; si was not smaller than di, find next
                xchg    si,di                   ; si was smaller than di, swap'em
                jmp     @@SortLoop1             ; and continue the search

; Write string in di to stdout
@@PrintString:
@@PrintLoop1:
                mov     ah,02h
                mov     dl,[di]
                int     21h
                cmp     al,0Ah
                je      @@StartSort
                mov     [di],bl
                inc     di
                jmp     @@PrintLoop1
; Quit
@@Exit:
                ret
                end
