; Assemble with NASM.
; Requires that program code file is put directly after filename on
; command line, e.g. "entry test1.b < blah > blah", not
; "entry  test1.b < oops".  If no filename is specified, or the file is not
; found, the program will be read from STDIN, due to BX=AX which is error 2.
;
; 02/11/1999    198 bytes
; 02/12/1999    197 bytes, moved code to take out near jmp
; 02/12/1999    183 bytes.  Quite a bit of restructuring!
; 02/12/1999    181 bytes.  Nice LODSB
; 02/12/1999    179 bytes!
; 02/16/1999    166 bytes! Took out clunky character reading and writing code
;               165 bytes.  Started using SCASW to change DI
;               164 bytes. Changed Loop Skipping code
;               163 bytes. Re-arranged startup and loading code
;               161 bytes. Re-arranged code to take out short jmp
;               160 bytes. Enhanced Loop Skipping code again!
;               158 bytes. changed two MOV x,AXs into XCHG x,AXs to save 2!
; 02/19/1999    155 bytes. Changed entry code.
; 03/13/1999    139 bytes. Changed quite a bit of stuff, but forgot to update
;                          the change list.  Mostly small algorithm
;                          optimizations.
; 03/15/1999    140 bytes. Had to fix a potential bug in the ] function.

; benl@mosquitonet.com, Alaska, USA.

org 100h

        mov bl,80h                      ; Load BX with offset of number of chars
        lea dx,[bx+2]                   ; in the command tail.  BH is zero!
                                        ; Load DX with offset of filename.
        add bl,[bx]                     ; Get position of space after filename.
        mov [bx],bh                     ; Write a zero.  There MUST be a space
                                        ; after the BF source file.  e.g.
                                        ; ENTRY.COM TEST2.B *enter*
                                        ; instead of ENTRY.COM TEST2.B*enter*
                                        ; TESTIT.BAT works fine, since
                                        ; all input is redirected, so the <
                                        ; is one space after the end of the
                                        ; BF filename.

        mov ah,3Dh                      ; Open file function
        int 21h                         ; Call DOS interrupt
                                        ; DX points to filename now

        xchg bx,ax                      ; Put file handle in BX
                                        ; this is one instruction, as opposed
                                        ; to mov bx,ax
        mov ah,3Fh                      ; Read from file.
        mov ch,28h                      ; 10240 bytes at minimum.
        mov dh,10h                      ; Write to DS:1082h
        int 21h
        xchg di,ax                      ; Move AX into BP
        mov si,dx                       ; Code pointer at DX!
        add di,si

        xor ax,ax                       ; Clear write value
        rep stosw                       ; Clear 10240 words of the memory

RightCarrot:                            ; This is called when a '>' is called.
        dec di                          ; The data is lined up backwards, so
        dec di                          ; > decrements, < increments.
ML0:    lodsb                           ; Load character from code!
        test al,al
        jz MEnd
        cmp al,'>'                      ; Test for a right carrot.
        jz RightCarrot                  ; Jump if we have one!
        cmp al,'<'                      ; Test for a left carrot
        jnz MP0
        scasw                           ; Increment DI by 2.
MP0:    cmp al,'+'
        jnz MP1
        inc word [di]                   ; Pretty self explainatory....
MP1:    cmp al,'-'
        jnz MP2
        dec word [di]
MP2:    mov ah,06h                      ; Read char as unsigned int from stdin
        cmp al,','                      ; 06h is used by the write char
        jnz MP5                         ; function as well, and so can be set
MP3:    cwd                             ; now.
        dec dx                          ; AH bit 7 is not set, so DX will be
        int 21h                         ; 0.  Then decrement it to make FFFFh
        jz MP4                          ; call interrupt and see if char
        cmp al,0Dh                      ; available.  If not, jump.  Compare
        jz MP3                          ; with enter and reload char if so.
        mov ah,cl                       ; Zero high byte of AX.
        xchg dx,ax                      ; Put AX in DX, and keep FFFFh in AX
MP4:    mov [di],dx                     ; Write the unsigned int.   If we 
                                        ; jump to here after int 21ing up
                                        ; higher, AL should be 0 if no char.
MP5:    cmp al,'['                      ; Compare with start of while.
        jnz MP6                         ; If not, check for next function
        cmp [di],cx                     ; Check for zero [dp]
        jz WhileSkip                    ; If it's zero, skip this while.
        push si                         ; Otherwise push current "IP" on stack
                                        ; AL is preserved

MP6:    cmp al,']'                      ; Test for end of loop
        jnz MP7                         ; If not, go to next function
        pop ax                          ; Pop last while's "IP" from stack.
        cmp [di],cx                     ; if it's zero, we don't go back to
        jz ML0                          ; the start of the while, just 
        xchg si,ax                      ; continue.  Otherwise we do go back
        push si                         ; to start, and push "IP", too.
        aaa

MP7:    cmp al,'.'                      ; Test for char write. AH still eq 06h
        jnz ML0                         ; If not, go back home.
        cmp byte [di],byte 0Ah          ; Compare with 0Ah.
        jb MP8                          ; If it's below, could be a tab, so
        mov ah,02h                      ; don't modify the function call.
        jnz MP8                         ; If it's NOT 0Ah, just write the 
        mov dl,0Dh                      ; char.  Otherwise write a 0Dh first.
        int 21h                         ; Write.
MP8:    mov dl,[di]                     ; Load actual char to write..
        int 21h                         ; and write it.
        jmp short ML0                   ; And go home

WhileSkip:                              ; First time through we increment
WSP1:   inc cx                          ; CX to count first bracket.  Later
WSL0:   lodsb                           ; We use it just to increment CX 
        cmp al,'['                      ; when we encounter another opening
        jz WSP1                         ; bracket, here.
WSP0:   cmp al,']'                      ; Compare with an ending bracket..
        jnz WSL0                        ; If it is not an ending, just loop.
        dec cx                          ; Otherwise decrement CX.
        jnz WSL0                        ; If it's zero, we've skipped the
        jmp short ML0                   ; loop that we set out to skip.

MEnd:   ret                             ; Begone!
