;ENTRY_6E.ASM	02-24-1999	110d byte interpreter for Hugi competition #6
;
; An optimization of Ruud's public entry with fixes
;
				.RADIX 16
ONLY	SEGMENT
			ASSUME CS:ONLY,SS:ONLY,DS:ONLY,ES:ONLY
				ORG 100
;******************************************************************************
;*		      Copyright (C) Lawrence E. Boothby 1999		      *
;*		     Contract programming <boothbyl@reed.edu>		      *
;*									      *
;* EXECUTION ENVIRONMENT ASSUMPTIONS:					      *
;*		Direction flag = 0, BX=0000, CX=00FF, DX=CS=DS, DI=SP=0FFFE   *
;*   WARNING!	Using DX=CS, program requires 019Fh<=CS<=3280h and DI=0FFFE   *
;*		MSdos version 3.XX+ (ver. 2.11 didn't MOV BP,SP during load)  *
;*		LOADHIGH will fail because using fcb at PSP:005C and this     *
;*		will be "LOADHIGH" moving fcb for "TEST?.B to PSP:006C	      *
;*		Program source file is in current directory or device CON     *
;*   WARNING!	Error handling for open fcb and random block read is disabled *
;*									      *
;* INPUT ASSUMPTIONS:							      *
;*		Max source file length = 10,000 = 2710h bytes		      *
;*		Source file is correct ( []'s match, <>'s don't violate	      *
;*		bounds of 10,000 word [dp], no embedded 00h, etc.)	      *
;*		Nesting level of []'s do not exceed stack space		      *
;*									      *
;******************************************************************************
START:		SHR	DI,1		;0FFFE -->7FFF
		MOV	SI,DX		;= CS, save DTA before destroy below
		MOV	AH,1A		;set DTA = DS:DX
		INT	21		;impossible to fail this function
		MOV	AH,0F		;open fcb
		MOV	DX,005C		;fcb already parsed by load function
		INT	21
	       ;or	al,al		;00=directory entry found
	       ;jnz	Exit
; Random Block Read function pads partial record with zero's. We can set the
; record size field large enough to read all of the input file (max 2710h) + the
; byte to terminate input file = 2711h + 4E20 for the initialization of the data
; area. Want to SHR DI,1 = 7FFF to save byte over MOV DI,XXXX. Random block read
; has the convenient property of returning CX = number of records read = 0001.
; If we use a record size of CC80, this limits load the load CS to the range
; CE1F-CC80=019F minimum and FF00-CC80=3280h maximum. MSdos has set the relative
; relative record field = 0000:0000 (when parsing command line for PSP, not
; during the open fcb call.
;
		MOV	BYTE PTR DS:[006Bh],0CC ;high byte record size (low=80)
		MOV	AH,27		;random block read
		;CX = 00FF from initial value which is > required of 0001
		INT	21
	       ;jcxz	Exit		;would handle 0 length source file
	       ;cmp	al,03		;= EOF, partial record (rest padded)
	       ;jnz	Exit
	       ;additional error checking that file not so large that it
	       ;would overwrite the supposedly zeroed data area.
;**************---------------**************************************************
	       ;BX=0000 and CX=0001 (from function AH=27h) now
	       ;program will fall through to first lodsb below
;**************---------------**************************************************
TryMoreLess:	SUB	AL,'<'
		JNZ	TryMore
		DEC	DI			;handle '<'
		DEC	DI
	       ;CF=0, AL = 00 so will take the JNB ParseSource below
;**************------------*****************************************************
TryRead:	CBW
		DEC	AX			;no change to CF
		JZ	GetChar
TryPlusMinus:	JNB	ParseSource
		SUB	[DI],AX			;+ or - 0001
;**************-------------------**********************************************
TryMore:	SUB	AL,02
		JNZ	TryPlus
		SCASW				;handle '>' (to INC,INC DI)
TryPlus:	MOV	DX,DI			;DTA
		SUB	AL,'+' - '>'
		CMP	AL,'.' - '+'
		JNZ	TryRead
;**************-----------------------******************************************
		INC	BX			;to BX=0000 = sto
		CMP	BYTE PTR [DI],0A
		JNZ	GetChar			;if not 0A
Swap:		XOR	BYTE PTR [DI],07	;convert 0A-->0Dh-->0A
Getchar:	MOV	AH,3F			;  read byte from sti, BX=0000
		ADD	AH,BL			;or write byte to sto, BX=0001
		;CX=0001 and DX=DI from above
		INT	21
FixMidZ:	DEC	AX			;count - 01 (sets AH=00 for us)
		JS	Okay			;EOF, AX=0FFFF from DEC AX
		MOV	AL,[DI]			;get character read
		CMP	AL,0Dh			;(impossible value for putchar)
		JZ	Swap			;go get the 0A after this 0Dh
	       ;CMP	AL,1A			;^Z
	       ;JZ	FixMidZ			;(until DEC AX,JS Okay)
Okay:		DEC	BX
		JZ	ParseSource
		MOV	[DI],AX			;update for getchar
		INC	BX			;restore BX=0000
;**************-----------------************************************************
ParseSource:	LODSB			;get next instruction
		CMP	AL,'['
		JNZ	TryClose
		PUSH	CX		;save skip flag of current level
		CMP	[DI],CX		;CX=0000 or 0001
		SBB	CX,BX		;when [DI]=0000 make CX=0000
		JCXZ	ParseSource
		PUSH	SI		;save pointer to instructions in []
TryClose:	CMP	AL,']'
		JNZ	CheckSkip
		JCXZ	Skip
		POP	SI
		DEC	SI		;back to '['
Skip:		POP	CX		;skip flag of previous nesting level
CheckSkip:	JCXZ	ParseSource
		OR	AL,AL		;dec, jns, would exit on 80h-FFh
		JNZ	TryMoreLess
Exit:		RET			;case lodsb AL=00
;*******************************************************************************
ONLY	ENDS
	END	START
