;MetalBRAINFUCKer
;----------------

;Brainfuck interpreter coded by: METALBRAIN (metalb@www.esi.us.es) from Spain
;       for the Hugi Size Compo #6
;Use NASM to compile

;Start date: 22/01/99

;Changelog: 189 (First try, bugs everywhere, nothing works),211 (incomplete,
;    as non-redirected EOF is not detected, but passes testit V1),197 (EOF
;    from STDIN is now detected),179,172 (Release 1 -> got a nice 3rd place
;    (it sounds better than saying that I was the last)),169,167,159,158,155,
;    151,148 (Release 2),146,151 (Added useless feature -> ^Z now produces an
;    EOF as (I thought) it should),149,153 (Bugfix -> No more TAB expansion
;    -> passes testit V2),150,149,147 (Release 3),145 (Release 4),144
;    (Release 5),143 (Release 6 -> Passes the new testit V3),137 (Release 7
;    -> Disabled the useless feature of ^Z treatment),135 (Release 8 ->
;    Passes the new testit V4),134,132,131,130 (Release 9),128 (Release 10),
;    127 (Release 11),126 (Release 12),124 (Release 13)

;Last version:
;        8/03/99 > 124 bytes.

; I am assuming DI=0FFFEh, SI=100h, BL=0 at startup, and only a space between
;ENTRY and brainfuck source file (so its name starts at 130 in PSP)


                ORG     256

                mov     dx,130          ;PSP first argument uses to be here
                mov     ch,253          ;Many bytes, and 253 = hidden std
tryopen:        mov     [si],bl         ;Try to make file name asciiZ
                mov     ah,3dh
                dec     si
                int     33              ;Open?
                jc      tryopen-1       ;If not: try again, executing std too
                xchg    ax,bx           ;BX=handle (with BH=0)
                mov     dh,82           ;Somewhere in the middle, and leave
                                        ;       plenty of stack free for loops
                rep     stosb           ;Clear data and program zone backwards
                inc     di              ;DI is brainfuck's DP
                dec     cx              ;65535 is more than 10000
                mov     si,dx           ;SI is brainfuck's PC
                mov     ah,3fh
                int     33              ;Read brainfuck program
                inc     cx
dontexit:       inc     cx              ;cx = 1 (read/write 1 char)
notestend:      cld                     ;Go forwards again
                lodsb                   ;Load code in al
                cbw                     ;AH=0 if valid code
                mov     dx,di           ;Read or write at [DP]
                sub     al,43           ;Test for +
                setz    bl              ; (Pretty odd instruction ;-)
                add     [di],bx         ;+ or BX=0
                dec     ax              ;Test for ,
                jnz     next02
                mov     [di],ax         ;,   Zero the cell
another:        mov     ah,3fh
                int     33              ;Read char
                cmp     [di],byte 0dh   ;Is 0dh?
here0d:         jz      another         ;If yes: Ignore it and read next 0ah
next03:         dec     ax
                add     [di],ax         ;EOF or -
next02:         dec     ax              ;Test for -
                jz      next03
                dec     ax              ;Test for .
                jnz     next04
                inc     bx              ;.
                mov     ah,40h
                cmp     [di],byte 0ah   ;Check for 0ah
                jnz     putthis
                pusha
                mov     dx,here0d-1     ;Point to 0dh
                int     33              ;Put 0dh
                popa
putthis:        int     33              ;Put char
next04:         sub     al,16           ;Test for >
                jz      next05
                add     al,2            ;Test for <
                jnz     next06
                std                     ;<
next05:         scasw                   ;> and <
next06:         sub     al,31           ;Test for [
                jz      startloop
                sub     al,2            ;Test for ]
                jnz     testend
                pop     si              ;]
startloop:      cmp     [di],bx         ;[ (and ])
                jz      nodec
                push    si
                jmp     short notestend
yeinc:          inc     cx              ;Skip all loop
nodec:          lodsb
                sub     al,91           ;Test for [
                jz      yeinc
                sub     al,2            ;Test for ]
                jnz     nodec
testend:        loop    nodec
                cmp     [si],ch         ;Test if we are in the end
                jnz     dontexit
                ret
