cseg segment
        assume cs:cseg, ds:cseg, ss:cseg
        org 100h
        .386

        ;+------------------------+             24/02/1999
        ;| Written By Jimmy Moore |
        ;|     jimmy@provenst.com |
        ;+------------------------+

start:
        sourcetest      equ     3000h   ; source buffer starts at 3000h
        databuffer      equ     60h     ; data buffer starts at 60xxh


        mov di, sourcetest
        mov ch, databuffer              ;; databuffer    cx = 60ffh

        push di
         push cx                        ; ax assumed to be 0
        rep stosw                       ; Clear source + databuffer
         pop di
        pop si

        mov ah, 1ah
        mov dx, si
        int 21h

        mov ah, 0fh
        mov cl, 5ch                     ; Length and addr of FCB
        mov dx, cx
        int 21h                         ; Open FCB

        mov ah, 27h
        int 21h                         ; Read FCB

;============================================================================;
;== Main                                                                    =;
;============================================================================;

loopi:  lodsb                   ; Get byte from source
        or al, al
         jz retdon              ; 00 = [--- EXIT ---]
        mov cl, 1               ; \
        mov dx, di              ; / Just incase int 21h i/o
;-------------------------------;====================
        sub al, 2bh             ; '+' '.' '-' ','
        cmp al, 3
         ja notme1              ; None of these
         jne no_do              ;
;-------------------------------; [2e] - dot
is_do:  mov bx, cx
        cmp byte ptr [di], 0ah
         jne nned0d
        mov dx, offset myda     ; do a 0dh, 0ah
        inc cx                  ;
nned0d: mov ah, 40h
        jmp doint1              ; Write byte... al should be 1 after - no err

;-------------------------------;
no_do:  cbw                     ; sign extends al to ah
        dec ax                  ; ax = -1 0 1
         jnz no_co
;-------------------------------; [2c] - comma
is_co:  xor bx, bx
        mov [di], bx            ; Clear data
        mov ah, 3fh
doint1: int 21h                 ; Read byte
        cmp byte ptr [di], 0dh
         je is_co               ; Get second byte (0ah)
        xor al, cl              ; If zero, then error -> set ax = 1
                                ; If 1, then ok... set ax = 0 and fall through
no_co:  sub word ptr [di], ax   ; [2b] or [2d]   -1 or +1   (or 0)
;-------------------------------; >>> Fall Through (ax = -1 0 1) <<<

notme1: sub al, (3ch - 2bh)     ; '<'
        cmp al, 2
         ja notme2              ;      <   >
        cbw                     ; ax = 0 1 2
        dec ax
        add di, ax
        add di, ax
notme2:
;-------------------------------; >>> Fall Through (ax = -1 0 1) <<<
no_03:  cmp al, '[' - 3ch
         jne no_04
        cmp word ptr [di], cx   ; (cx = 1)
         jb fiend               ; Go to end of loop if zero
        push si                 ; Push current Source addr for loop.
;-------------------------------;
no_04:  cmp al, ']' - 3ch
         jne no_05
        pop si
        dec si                  ; Get back to '['
;-------------------------------;
no_05:  jmp loopi
;============================================================================;
fiend:  mov bl, -1
fend:   lodsb
        sub al, 5bh             ; 0 or 2        (1 doesn't matter)
        cmp al, 2
         ja fend
        dec ax                  ; -1 0 1
        add bl, al
         jnz fend               ; jump if not equal.
        jmp loopi
;============================================================================;
retdon: ret

myda:   db 0dh, 0ah

cseg ends
        end start

