; ***************************************************************************
;
;           Hugi Competition No. 6 : Brainf**k Programming Language
;           =======================================================
;
;               A Compiler by Paul Robson (autismuk@aol.com)
;
;                    Date 31st January 1999 : Version 1.1
;
;       This compiles the program into x86 assembler code and then runs it,
;       actually shorter than my interpreter. If not the shortest entry it
;       is almost certainly the fastest :-) Unfortunately as the code is
;       quite neat theres no opportunity for swindling bytes out of it :-(
;
;       I felt unable to enter an interpreter as I read the 132 byte "public"
;       version.
;
;       Code Size = 147 bytes
;
;       Fixes for Version 1.1 : TAB (Chr(9)) was not expanded.
;
;       In the Compiler Phase :-
;
;               CX      00??
;               SI      Search Table Pointer
;               DI      Target address
;               BL      File Handle
;               BP      Program Memory Address (initially 09xx)
;
;       In the Runtime Phase :-
;
;               DI      Data Pointer
;               BX      0000    [except in ,]
;               CX      0001
;
; ***************************************************************************

MSDOS = 21h
   
; ***************************************************************************
;                               Open file for input
; ***************************************************************************

        mov     di,bp                   ; DI points to program memory somewhere
        mov     ch,0F0h                 ; clear 09xx to F9xx+00FF
        rep     stosb

        shr     si,1                    ; make SI = $80
        lodsb                           ; AX = Length now
        xchg    ax,bx                   ; AX = 0,BH = 0,BL = Length
        mov     [si+bx],ah              ; make string ASCIIZ

        mov     ah,3Dh                  ; MSDOS "Open File" Function
        mov     dx,82h                  ; DX is the file name pointer
        int     MSDOS
        xchg    ax,bx                   ; AX=00ll,BX=3Dhh,CX=0000,DX=CSDSESSS

; ***************************************************************************
;
;   Compiler phase. At this point DL contains the character to be compiled.
;
;   Except for [ and ] this simply involves looking up the code in the
;   compiler table & copying the appropriate code.
;
;   [ and ] save/restore loop addresses on the stack. ] also patches back.
;
; ***************************************************************************

        mov     di,bp                   ; get program memory pointer 09xx

Compile:
        mov     dx,di                   ; set the read pointer to DI
        inc     cx                      ; read 1 byte (CX=0 before)
        mov     ah,3Fh                  ; from the input file
        int     MSDOS
        dec     ax                      ; if EOF then this will set S
        js      short Exit              ; and the compile phase is complete

        mov     si,CompilerData-1       ; set the compiler pointer
                                        ; CX is one now, the -1 offsets this

CompileLoop:
        add     si,cx                   ; add the offset (0 first time round)
        jcxz    short Compile           ; if offset 0 then it's over...
        lodsb                           ; get the size of the code
        xchg    ax,cx                   ; put in CL [now CX = 00ss,AX = 00??]
        lodsb                           ; AX = 00cc where cc is the character
        cmp     al,[di]                 ; did it match ?
        jne     short CompileLoop

        cmp     al,'['                  ; open loop ? If so, save the current
        jne     short NotOpen           ; program pointer for later processing
        push    di                      ; (address at the TOP of the loop)
NotOpen:

        rep     movsb                   ; compile code from SI to DI
        cmp     al,']'                  ; close loop ? if not, do the next bit
        jne     short CompileLoop

        pop     si                      ; this is the "loop back" address
        mov     [si+5],di               ; patch the push which is abs jump
        mov     [si+9],si               ; patch the push which is loop back

        jmp     short Compile           ; and compile the next bit

; ***************************************************************************
;
;                 End of Program ; Prepare to run & do it !
;
; ***************************************************************************

Exit:   mov     al,0C3h                 ; compile a RET to go back to DOS
        stosb
        xor     bx,bx                   ; clear the I/O Handle to stdin
        jmp     bp                      ; and go to the compiled program

; ***************************************************************************
;                              Compiler Data Table
;     Byte 0 Code Length : Byte 1 Character : Byte 2+ Code to compile
; ***************************************************************************

CompilerData:
        db      2,'+'                   ; Inc [dp]
        inc     [word ptr di]
        db      2,'-'                   ; Dec [dp]
        dec     [word ptr di]
        db      2,'>'                   ; Inc dp
        inc     di,2
        db      2,'<'                   ; Dec dp
        dec     di,2
;
;       Open Loop. Both of the constant pushes are patched to 'real'
;       values in the compiler core as part of "close loop".
;
        db      OpenEnd-OpenStart,'['   ; loop open code

OpenStart:
        cmp     [di],bx                 ; check if TOS = 0
        jnz     short _NoPatch
        push    1234h                   ; this address is the EXIT address
        ret                             ; it is an absolute jump effectively
_NoPatch:
        push    1234h                   ; this address is the CONTINUE address
                                        ; which is what the ret in ] uses
OpenEnd:
;
;       Close Loop
;
        db      1,']'                   ; loop close code (also does patching)
        ret                             ; pop the address off the stack
;
;       Read Character
;
        db      ReadEnd-ReadStart,','   ; Read [dp]
ReadStart:
        mov     ah,3Fh                  ; CX is already set to '1',BX to zero
        mov     [di],bx                 ; clear it initially
        mov     dx,di                   ; set the target address
        int     MSDOS                   ; call the MSDOS function
        dec     ax
        jns     short ReadCheck         ; if EOF
        mov     [di],ax                 ; set the word to -1
ReadCheck:
        cmp     [byte ptr di],0Dh       ; and ignore CRs
        je      short ReadStart
ReadEnd:
;
;       Write Character
;
        db      OutEnd-OutStart,'.'     ; Write [dp]
OutStart:
        mov     ax,020Ah                ; AH := DOS:StdOut AL := LineFeed
        cmp     al,[di]                 ; if line feed to be printed...
        jne     short OutChar
        mov     dl,0Dh                  ; output CR first
        int     MSDOS
OutChar:mov     dx,di                   ; output the character at [DI]
        inc     bx                      ; to stdout
        mov     ah,40h                  ; using WRITE
        int     MSDOS
        dec     bx                      ; restore BX
OutEnd:

        db      0                       ; end of table marker.

;
;       Note : if this matches (probably on 00,90) it will still work
;       because it will compile 0 bytes of code (REP MOVSB does nothing)
;
;
