;Entry for Brainfuck program [hugi]
;
;By Ruud v Gessel
;   11-03-1999
;
;   size : 98 bytes
;
;use :     tasm  /ml entry
;          tlink /t entry

by equ byte ptr
wo equ word ptr
of equ offset ds:

                 .model    tiny
                 .286                           ;Not going to use 386+

                 .code

                 ORG       100h

Start:           mov       ax,1a5ch
                 int       21h                  ;DTA at ds:dx
                 cbw                            ;Need 005ch
                 xchg      ax,dx                ;Dx at FCB
                 xchg      si,ax                ;Si at DTA = Code buffer
                 mov       ah,0fh
                 int       21h                  ;Open the file
                 mov       ah,27h               ;Ax=2700h
                                                ;  2700h --> nesting level
                                                ;            2700h/4 = 2496
                                                ;Code + data buffer size
                                                ;  d8fd-dx
                 sub       [bx+5ch+0eh],ax      ;Clears 80h more bytes
                                                ; Ensures [di]=0
                 int       21h                  ;Read file and zero buff's

@l0x:            scasw                          ;From dec PTR = '<' (ax=0)
@l0y:            sub       di,ax                ;From inc PTR = '>' (ax=2)
                                                ;Init ==> -2703h
;*** At this point : 
;
;    AX = 2703h -> AL is regarded a NOP
;    BX = 0000h (Not importand)
;    CX = 0001h (always 1 record read, brf size < 10000) -> executing
;    DX = 005Ch (Not importand)
;    SI = CS    Points to first char of brf file
;    DI = d8fdh TOP of data buffer.. Expands down ! '>':di-=2, '<':di+=2
;    SP = fffeh leaving 2700h stack bytes, (SP-DI)/4 -> nexting level > 2400
;    All bytes between top of brf code and top of data buffer are 0

@l00:            cmp       al,']'
                 jne short @l01
                 jcxz      @l02                 ;> Only exec flag, no loop
                 pop       si
                 dec       si
@l02:            pop       cx                   ;Exec flag

@l01:            push      cx
                 sub       al,'['
                 jne short @PopBx
                 push      si
                 cmp       [di],ax
                 jnz short @NoPopBx
                 xchg      ax,cx                ;Cx = 0 !!!
@PopBx:          pop       bx                   ;bx=cx if al!='['
@NoPopBx:        jcxz      @l11

                 xor       al,0e1h
                 jz  short @l0x                 ;>> scasw; sub di,ax (ax=0)
                 cmp       al,2
                 jz  short @l0y                 ;>> sub di,ax (ax=2)

;                xor       al,32h               ;'.'=0, '-'=1, ','=2, '+'=3
;                je  short @l06                 ;_puthchar
;                cmp       al,4
;                jnc short @l11                 ;>> Test for '<>' only
;                dec       ax
;                dec       ax
;                jnz short @l08                 ;>> Must be '-+'
;                dec       bx                   ;_getchar need bx=0
;                mov       [di],ax              ;Zero extended for _getchar

                 xor       al,33h
                 cmp       al,3
                 ja        @l11
                 dec       ax
                 jz        @l06
                 jc        @l08
                 dec       bx
                 mov       [di],bx

@l06:            cmp       by [di],0ah
@l060:           mov       ax,3f07h
                 jnz short @l061                ;>> Don't translate 0a->0d0a
                 xor       [di],al              ;Change 0d->0a, 0a->0d
@l061:           add       ah,bl
                 mov       dx,di
                 int       21h                  ;putchar or getchar
                 cmp       by [di],0dh
                 je  short @l060                ;>> repeat if 0dh
                 dec       ax                   ;Convert 0=>-1, 1=>0

                 ;*** '-'(-1) or '+'(+1) and -1 for EOF
                 
@l08:            add       [di],ax              ;Always OK at this point...

                 ;*** '<' or '>' command

@l11:            lodsb
                 db        0d5h,0               ;Thanx TAD
                                                ;AAD 0, ah=0, cmp al,0.
                 jne short @l00                 ;Do until last command
                 ret

                 end       Start

