;
; 121 bytes long
; -> BrainFuck interpreter <-
; for hugi-compo #6
;                  
;                  
;  by             of Mnemonic
;              
;                  
;
; shr@demozone.org
; 25. March, 1999.
; Hungary
;

.model tiny
.386
.code
org 100h

b equ byte ptr
w equ word ptr

;assume:  ax=0, bx=0, cx=0FFh, si=100h, di=0FFFEh, d flag = 0
       ;  at start

start:
    shr si,1        ;si=80h, b [si]=parameter length
    lodsb
    xchg ax,bx      ;ax=0, bh=0, bl: parameter length
    mov [si+bx],al  ;ASCIIZ string

    std
    mov ch,0FDh     ;cx=0FDFFh, ax=0
    rep stosb       ;->cx=0
    cld             ;fill DS:200h-FFFEh with zeroes
    inc di          ;di at start of datas

;open file
    mov ah,3dh      ;al=0
    mov dx,82h      ;ASCIIZ filename
    int 21h         ;->ax:handle

    mov dh,52h      ;->dx=5282h
    mov si,dx

;read proggy from file
    xchg ax,bx      ;->bx:handle
    mov ah,3fh
    dec cx          ;->cx=0FFFFh is enough :)
    int 21h

    inc cx
    inc cx          ;->cx=1

;di=200h    start of datas (filled with zeroes)
   ; 10240 word
;si=5200h   start of BrainFuck source program (zero in the end)
   ; far enough room for a 10000 bytes long source + stack...

;during interpretation cx=1 means we are in "execution mode"
;cx=0  "read only" mode, we read a '[' but in the current data cell was a zero
        ;we have to read program (but not execute it) till the adequate ']'

interpret:          ;cx=1 or cx=0 always
    mov dx,di
    lodsb
chk_0:
    cmp al,'['
    jnz chk_1
loop_start:
    push cx
    push si
    cmp [di],cx  ;compute new value of cx
    sbb cl,ch
chk_1:
    cmp al,']'
    jnz chk_1b
    pop bp
    jcxz goingon
    mov si,bp
    dec si
goingon:
    pop cx
chk_1b:
    jcxz interpret  ;if cx=0 and input is legal, al<>0
    cbw
chk_2:
    mov bx,cx       ;->bx=1
    sub al,'+'      ;->+,-. 0/1/2/3
    cmp al,3
    ja chk_3
    jz putchar
    dec ax          ;->+,-  -1/0/1
    jnz nongetchar
;GETCHAR/PUTCHAR
getchar:
    mov [di],ax     ;sign extension
    xchg ax,bx      ;->bx=0 - getchar
putchar:            ;bx=1 - putchar
    cmp b [di],0Ah
    jnz putOK
    mov b [di],16
cyc:
    sub b [di],3
putOK:
    mov ah,3Fh
    add ah,bl
    int 21h
    dec ax
    jns non
endofinput:
    mov [di],ax
    inc ax          ;->ax=0
non:                ;ax=0
    cmp b [di],0Dh
    jz cyc
;ax=0, end of getchar/putchar
nongetchar:
;+/-  ax=-1/+1  or ax=0
    sub [di],ax
chk_3:
    sub al,'<'-'+'
    cmp al,2
    ja check4zero
;<=> 0/1/2
    dec ax
    shl ax,1
;-1/0/1
    add di,ax
check4zero:
;al=    if last read byte was
;   31          '['
;   33          ']'
;  238          '+'
;  240          '-'
;  239          ',' or '.'
;  255/0/1      '<' '=' '>'
    cmp al,196    ;if last read byte was a zero, al=196 else not
    jnz interpret

    ret

end start