[ Text2BF version 2

  This program converts an ASCII text into a Brainfuck program which
  prints this text, generated program is formatted to 72 columns

    by Stefan Reuther <Streu@gmx.de> ]

Cells minus1 to minus6 = temp space
Cell 0 = previous character
Cell 1 = ditto
Cell 2 = current character
Cell 3 = status flag
Cell 4 = '+'
Cell 5 = '-'
Cell 6 = dot
Cell 7 = column countdown
Cell 8 = temp flag
Cell 9 = temp
Cell 10 = newline

make temp space
>>>>>>

make newline in cell 10
>>>>>>>>>>++++++++++

make characters in cells 4 to 6; column countdown in 7
<<+++++++++[-<++++++++<+++++<+++++<+++++>>>>]<<+<<--<<

pointer at cell 2
,+[-
  clear 0 and minus1
  <<[-]<[-]>>>
  copy 2 to 0 and minus1 (destructive)
  [-<<+<+>>>]
  copy minus1 to 2 (destructive)
  <<<[->>>+<<<]>>>

  now: 1 = prev char; 2 = this char; pointer at 2
  >+  set status flag to 1
  [
    pointer at status flag 3
    copy 2 to minus1; 1 to minus2
    <[-<<<+<+>>>>]<<<<[->>>>+<<<<]>>>>
    <[-<<<+<+>>>>]<<<<[->>>>+<<<<]

    pointer at minus3; minus3 = 0
    >[           minus2 is nonzero
      [-]        clear it
      >[         minus1 is nonzero
        [-]      clear it
        <<+>>    and set minus3
      ]<
    ]<
    minus3 is now one if 1 and 2 were nonzero
    >>>>>>[-]<<<<<<    clear status flag
    [                  if minus3 nonzero
       [-]
       >>>>->->+<<<<<< decrement and set status flag
    ]
    >>>>>>
  ]
  here 2 or 1 is zero; pointer at 3
  <[
    cell 2 nonzero
    [->>.            print plus from cell 4
      >>>-           column countdown
      copy countdown to 8; using 9 as temp
      [->+>+<<]>>[-<<+>>]
      now; 9 is zero; 8 = 7 = countdown; pointer at 9
      +<[[-]>-<]        set flag unless countdown nonzero
      >[                flag 1 = countdown zero
        [-]>.<          print newline
        ++++++++[<<+++++++++>>-]   and reset countdown to 72
      ]
      <<<<<
    <<]
    <[-]>   clear cell 1
  ]
  <[
    cell 1 nonzero
    [->>>>.          print minus from cell 5
      >>-            column countdown
      copy countdown to 8; using 9 as temp
      [->+>+<<]>>[-<<+>>]
      now; 9 is zero; 8 = 7 = countdown; pointer at 9
      +<[[-]>-<]        set flag unless countdown nonzero
      >[                flag 1 = countdown zero
        [-]>.<          print newline
        ++++++++[<<+++++++++>>-]   and reset countdown to 72
      ]
      <<<<
    <<<<]
    >[-]<   clear cell 2
  ]
  pointer at cell 1; cells 1 and 2 zero; print dot
  >>>>>.        print dot from cell 6

  >-            column countdown
  copy countdown to 8; using 9 as temp
  [->+>+<<]>>[-<<+>>]
  now; 9 is zero; 8 = 7 = countdown; pointer at 9
  +<[[-]>-<]        set flag unless countdown nonzero
  >[                flag 1 = countdown zero
    [-]>.<          print newline
    ++++++++[<<+++++++++>>-]   and reset countdown to 72
  ]
  <<<
  <<<<<
  copy 0 to 1 (destructive)
  <[->+<]>>
,+]

[-][
Local variables:
font-lock-keywords: (("[^][<>+,.-]+" . font-lock-comment-face))
End:
]
