;
;  Stefan's entry for Hugi Size Coding Competition #6
;  - Brainf*ck Interpreter
;
;  Supports 10000 bytes of program text, 10000 words of data
;  Requires BX = 0 at startup
;  Assumes source file in current working directory (FCBs)
;
;  tasm /m entry
;  tlink /t entry
;  => 123 bytes
;
;  Enjoy,
;    Stefan <Streu@gmx.de>
;

                MODEL   TINY
                CODESEG
                ORG     100h
		P386

CODESTART = 25Ch	; low byte == 5Ch
DATASTART = CODESTART + 10000

;=== Load File & Zero out memory ===
Start:          mov     dx,CODESTART
		mov	si,dx
		mov	ah,1Ah		; Set DTA to DS:DX
                int     21h
		mov	dh,0		; DX = 5Ch
                mov     ah,0Fh		; Open FCB
                int     21h
		mov	byte ptr [bx + 5Ch+0Fh], 75h ; BX=0 -> FCB record size
					; 7580h bytes = 10000 + 10000*2 + n
                mov     ah,14h          ; Sequential Read
                int     21h

;=== Interpreter Loop ===
                mov     di,DATASTART-1
                mov     al,']'
                stosb

IntLoop:        cld
		lodsb
		mov	bl,1		; BX = 1
                xor     cx,cx
                sub     al,'+'
		cbw
		jl	IntLoop		; "+" = 43
                dec     ax
                je      GetChar		; "," = 44
		cmp	al,2		; "-" = 45
                je      PutChar		; "." = 46
		jns	NoPlusMinus
		sub	[di],ax
NoPlusMinus:	sub     al,'<' - ','
                je      Left
                sub     al,2
                je      Right
                sub     al,'[' - '>'
                je      StartLoop
                sub     al,2
                jne     IntLoop
Return:         ret

;=== ,/. command ===
GetChar:	mov	[di+bx],bh	; set hi byte to 0
		dec	bx		; BX = 1 = STDOUT_FILENO
PutChar:        inc     cx              ; BX = 0 = STDIN_FILENO
		mov	dx,di
		cmp	byte ptr [di],10
		jne	Again
	Again1:	xor	byte ptr [di],(13 XOR 10)
        Again:  mov     ah,3Fh
		add	ah,bl
                int     21h
                dec     ax
		or      ax,[di]		; -1 for EOF, character code else
		cmp	al,13
		je	Again1
		stosw

;=== </> commands ===
Left:           std
Right:          scasw
                jmp     IntLoop

;=== [ command ===
	DoLoop:	push	si
		call	IntLoop
		pop	si
StartLoop:      cmp     word ptr [di],bx
                jnb     DoLoop		; fall through if zero
EndLoop:        inc	cx		; CX = 0 here
        LoopB:  lodsb
                sub     al,'['
                je      EndLoop
                cmp     al,2
                jne     LoopB
                loop    LoopB
                jmp     IntLoop

Eof             label   byte

                END     Start

Local variables:
font-lock-keywords: (
  ("^[-A-Za-z_0-9:]+" . font-lock-variable-name-face)
  (";[^\$\n]*$" 0 font-lock-comment-face t t)
  ("^[ \t]+[A-Z0-9]+\\b" . font-lock-keyword-face)
)
End:
