;Brainfuck interpretor for Hugi Compo 6

;by st0ne (111 bytes)



.model tiny

.486

.code



Ideal

        org     100h



;------------------------------------

start:



@clear: les     cx,[si+(@loop-start)]   ;cx=D5AC es=7500

        rep     stosw           ; 5     ;cx=0000 di=AB56

        

@asciz: shr     si,1

        lodsb

        xchg    bx,ax

        mov     [bx+si],al

        inc     si              ; 7     ;si=0082

        

@open:  mov     dx,si                   ;dx=0082

        mov     ah,3Dh

        int     21h             ; 6



@seg:   push    es

        pop     ds              ; 2     ;ds=7500



@read:  xchg    bx,ax                   ;bx=0005 ax=00xx

        dec     cx

        mov     ah,3Fh

        int     21h             ; 6     ;cx=FFFF



@init:  aaa                     ; 1     ;ax=xx0x



;------------------------------------

main:



;--------------------------------- 21



@begin: cmp     al,'['

        jne     @end

        push    cx              ;Save flag

        push    si              ;Save loop begining

        mov     cx,[di]         ;New flag



@end:   cmp     al,']'

        jne     @ret

        pop     bp

        jcxz    @e1             ;No loop

        lea     si,[bp-1]       ;Jump to loop begining

@e1:    pop     cx              ;Restore flag

        

@ret:   jcxz    @loop



;--------------------------------- 23



@left:  sub     al,'<'

        jne     @right

        scasw                   ;ax=0



@set:   sub     [di],ax         ;ax=0, 1,-1



@right: sub     al,'>'-'<'

        je      @io3



        sub     al,'.'-'>'

        je      @io



        sub     al,'+'-'.'      ;test if ,+-

        jb      @loop

        dec     ax

        jnz     @set            ;test if +-

        dec     ax



;--------------------------------- 34



@io:    inc     ax

        mov     bx,ax           ;set handle=stdin/stdout

        mul     [word di]       ;if input ax=0, if output ax=[di]

        mov     dx,di           ;buffer is ds:dx

        mov     cx,0001h        ;read/write one char [3 bytes !]

        

        cmp     al,0Ah          ;output 0D before a 0A

        jne     @io2

@io1:   xor     al,0Ah xor 0Dh

        

@io2:   mov     [di],ax         ;if input, we have ah=0

        mov     ah,3Fh          ;set ah for read/write

        add     ah,bl

        int     21h

        dec     ax              ;if EOF, ax=FFFF

        or      ax,[di]         ;else ax=[di]

        cmp     al,0Dh

        je      @io1            ;if it's 0D, replace it by 0A



        stosw

@io3:   dec     di

        dec     di



;--------------------------------- 6



@loop:  lodsb

        aad     00h             ;clear ah and test al

        jnz     main

        ret



        end     start