			bits	16
			org	0100h

			;
			;	Brainfuck Interpretor
			;		by Stefan Turner (UK)
			;			version 10.0
			;
			;	Assemble with:	nasm -f bin -o entry.com entry.asm
			;	Assembled size:	290 bytes
			;	Tested on:	Test Suite 5
			;

segment	.data

	ComTable:	db	IncMem - StartText, '+'
			db	DecMem - StartText, '-'
			db	IncPtr - StartText, '>'
			db	DecPtr - StartText, '<'
			db	LoopStart - StartText, '['
			db	LoopEnd - StartText, ']'
			db	Output - StartText, '.'
			db	Input - StartText, ','
			db	Exit - StartText, 0

	LenComTable	equ	$ - ComTable

segment	.bss

	Source:		resb	20224
	Mem:		resw	20096

segment	.text

	StartText:

			shr	si, 1
			mov	bl, [si]
			mov	[si+bx+1], al

			mov	di, Source
			mov	si, di
			mov	ch, 0ECh

			rep	stosb

			mov	ah, 3Dh
			mov	dx, 82h
			int	21h

			mov	bx, ax
			mov	ah, 3Fh
			mov	ch, 4Fh
			mov	dx, si
			int	21h

			mov	di, Mem
			dec	si

	NextCommand:

			push	word NextCommand

		.SkipPush:

			mov	cx, 1
			inc	si

			mov	bx, LenComTable + 2

		.NextEntry:

				sub	bx, 2
				jz	short NextCommand.SkipPush
				mov	ax, word [ComTable+bx-2]
				cmp	ah, byte [si]
				jne	short .NextEntry

				mov	ah, 01h

				jmp	short ax

	IncMem:

			add	word [di], 2

	DecMem:

			dec	word [di]
			ret

	IncPtr:

			add	di, 4

	DecPtr:

			sub	di, 2

	_Ret:

			ret

	LoopStart:

			cmp	word [di], 0000h
			jne	short _Ret

			neg	cx

	LoopEnd:

			mov	ax, 1

		.NextChar:

				sub	si, cx

				cmp	byte [si], '['
				jne	short .Skip

				sub	ax, cx
				jnz	short .Skip

				dec	si
				ret

		.Skip:

				cmp	[si], byte ']'
				jne	short .NextChar

				add	ax, cx
				jnz	short .NextChar
				ret

	Output:

			mov	ah, 40h
			mov	bx, cx

			cmp	byte [di], 0Ah
			jne	short .Skip

			mov	dx, CR
			int	21h

			mov	ah, 40h

		.Skip:

			mov	dx, di
			int	21h
			ret

	Input:

			mov	ah, 3Fh
			xor	bx, bx
			mov	word [di], bx
			mov	dx, di
			int	21h

			cmp	byte [di], 0Dh

			CR	equ	$ - 1

			jne	short Input.Skip
			mov	ah, 3Fh
			int	21h

		.Skip:

			test	ax, ax
			jz	Input.EOF

			cmp	byte [di], 1Ah
			jne	Input.Skip2

		.EOF:

			mov	word [di], 0FFFFh

		.Skip2:

			ret

	Exit:

			int	20h