;
;
; 		     Picture-Checker for the Hugi compo 7 
;				 by TAD 1999
;
;
;
;       This compares an entry's image & palette (the file  "ENTRY.RAW")
; 	 against the original image & palette (the file "HUGI.RAW").
;
;
;   It checks the file length (must be 64768) and the R,G,B values of pixels
;   so it allows for remapping of the image and palette while still checking
;	    that the actual picture remains identical to the eye.
;
;
; Compile:
;		TASM rawchk
;		TLINK rawchk
;		EXEMAX rawchk.exe
;

imagesize	equ	64768

INT_VIDEO	equ	<int 10h>
INT_KEYB	equ	<int 16h>
INT_DOS		equ	<int 21h>

;

code1 segment para use16
code1 ends

rawimage segment para use16
	db	(imagesize+1) dup (?)
rawimage ends

entryimage segment para use16
	db	(imagesize+1) dup (?)
entryimage ends

;

code1 segment
	assume	cs:code1, ds:code1, ss:code1
start:
	mov	ax,code1
	mov	ds,ax
	mov	ss,ax
	mov	sp,offset stacktop

	lea	dx,titletxt
	mov	ah,9
	INT_DOS

	;; load original raw image ;;

	lea	dx,rawfilename
	mov	di,rawimage
	call	loadimage
	lea	dx,CantLoadRaw
	jnc	short ok1
	jmp	reporterror
ok1:

	;; load entry image ;;

	lea	dx,entryfilename
	mov	di,entryimage
	call	loadimage
	lea	dx,CantLoadEntry
	jnc	short ok2
	jmp	reporterror
ok2:

	;; display raw "HUGI.RAW" image on screen ;;

	mov	ax,0013h
	INT_VIDEO

	mov	ax,rawimage
	mov	ds,ax
	sub	si,si

	mov	al,0
	mov	cx,768
	call	setcolours		; set palette

	mov	ax,0A000h
	mov	es,ax
	sub	di,di	 		; [ES:DI] --> Video ram
	mov	cx,64000
	rep	movsb			; copy image

	;; wait for a key ;;

	mov	ah,0
	INT_KEYB

;
;
; Now compare and display differencies between the "HUGI.RAW" and "ENTRY.RAW"
;  images by painting out matching pixels GREEN and incorrect WHITE.
;
;

	push	cs
	pop	ds
	lea	si,blackwhite
	mov	al,0
	mov	cx,6
	call	setcolours		; define colours 0 and 1

	;; now display differences between raw & entry images ;;

	sub	cx,cx			; incorrect pixel count = 0

	sub	di,di
compare:
	;; get raw R,G,B value for 1 pixel ;;

	mov	ax,rawimage
	mov	ds,ax			; [DS:0000] --> raw image

	mov	al,[di+768]		; get raw pixel
	mov	ah,3
	mul	ah   			; AX = pixel * 3
	mov	si,ax
	lodsw
	mov	bx,ax			; BL = Red, BH = Green
	lodsb
	mov	dl,al			; DL = Blue

	;; compare R,G,B values against ENTRY.RAW pixel ;;

	mov	ax,entryimage
	mov	ds,ax			; [DS:0000] --> entry image

	mov	al,[di+768]		; get entry pixel
	mov	ah,3
	mul	ah
	mov	si,ax
	lodsw
	sub	bx,ax
	lodsb
	sub	dl,al

	;; hide matching R,G,B pixel by plotting colour 0 ;;

	mov	al,1
	inc	cx			; assume incorrect

	test	bx,bx
	jnz	short wrong		; is Red or Green wrong ?
	test	dl,dl
	jnz	short wrong		; is Blue wrong ?

	dec	cx
	mov	al,0			; else plot pixel colour 0
wrong:
	stosb
	cmp	di,64000
	jnz	short compare		; compare all 64000 pixels	

	push	cs
	pop	ds
	push	cs
	pop	es
	assume ds:code1, es:code1
	mov	[matchcount],cx

	;; again wait for a key press ;;

	mov	ah, 00h
	INT_KEYB

	;; switch back to text mode 3 ;;

	mov	ax,0003h
	INT_VIDEO

	lea	di,infopoke
	mov	ax,[matchcount]
	call	outdec5

	lea	dx,infotxt
	mov	ah,9
	INT_DOS

	;; back to DOS... ;;

	mov	cx,[matchcount]
	jcxz	allokay
	mov	ax,4C02h
	INT_DOS				; quit error 2 (errors found)

allokay:
	mov	ax,4C00h
	INT_DOS				; quit error 0

;
; Report error[CS:DX] and quit
;
reporterror:
	push	dx
	push	cs
	pop	ds
	lea	dx,errortxt
	mov	ah,9
	INT_DOS
	pop	dx
	mov	ah,9
	INT_DOS
	mov	ax,4C01h
	INT_DOS				; quit error 1

;
; Output(AX) as 5 digit decimal into [DS:DI]
;
outdec5:
	mov	cl,0
	mov	bx,10000
	call	divdecimal
	mov	bx,1000
	call	divdecimal
	mov	bx,100
	call	divdecimal
	mov	bx,10
	call	divdecimal
	add	al,'0'
	stosb
	ret
divdecimal:
	mov	byte ptr [di],' '
	sub	dx,dx
	div	bx
	or	cl,al
	jz	short divzero
	add	al,'0'
	mov	[di],al
divzero:
	inc	di
	xchg	ax,dx
	ret


;
; Load image[DS:DX] into[DI:0000]
;

loadimage:
	mov	ax,3D00h
	INT_DOS
	jc	short loaderror
	xchg	ax,bx
	push	ds
	mov	ds,di
	sub	dx,dx
	mov	cx,(imagesize+1)	; try to load (imagesize + 1)
	mov	ah,3Fh
	INT_DOS
	pop	ds
	jc	short loaderror
	cmp	ax,imagesize
	jnz	short loaderror		; MUST only load imagesize !!
	mov	ah,3Eh
	INT_DOS
loaderror:
	ret


;
; Set colours[DS:SI] bytes(CX) start colour(AL)
;
setcolours:
	mov	dx,3C8h
	out	dx,al
	inc	dx
colorlp:
	lodsb
	out	dx,al
	loop	colorlp
	ret


matchcount	dw	?

blackwhite	db	0,32,0		; green = okay
		db	63,63,63	; white = error


titletxt	db	13,10,"TAD's 64768 byte image test suite V1.00"
		db	'$'


infotxt		db	13,10,"Image test suite V1.00 results:-"
		db	13,10
		db	13,10,'Compared "HUGI.RAW" against "ENTRY.RAW".'
		db	13,10
infopoke	db	'00000 incorrect pixel(s) found.'
		db	13,10
		db	'$'

errortxt	db	13,10,'**Error** $'

CantLoadRaw	db	"Can't load ""HUGI.RAW"" image",13,10,'$'
CantLoadEntry	db	"Can't load ""ENTRY.RAW"" image,13,10,'$'"

rawfilename	db	'HUGI.RAW',0
entryfilename	db	'ENTRY.RAW',0

		dw	800 dup (?)
stacktop	dw	?

code1 ends


	end	start
