{
  GENERATE
  Developed by Boo Khan Ming (Malaysia)

  Revision 1.0 (1999.5.12)

  E-mail: bookm@tm.net.my
  WWW:    http://www.geocities.com/SiliconValley/Horizon/3409


  This is my own compression technique.
  Two different compression techniques employed here.
  The palette is compact through 8-to-6 bit transformation.
  The image data is compact through frequency table.
}

const
  TemplateFileName='TEMPLATE.COM';
  ExecutableFileName='ENTRY.COM';

type
  ImageType=array [1..64000] of byte;

var
  Image:^ImageType;
  ImageSize:word;
  Buffer:array [1..2048] of byte;

  ImageFile:file;
  TemplateFile:file;
  ExecutableFile:file;

  Palette:array [1..768] of byte;
  CompactPalette:array [1..576] of byte;
  FrequencyTable:array [1..256] of word;
  FrequencyTableSize:byte;

  UsedColorList,UnusedColorList:array [1..256] of byte;
  UsedColor,UnusedColor:byte;

  FrequentlyUsedColorList:array [1..256] of byte;
  ColorMap:array [1..256] of word;

  Counter:word;
  Size:word;
  Loop:word;
  Code:byte;
  Frequency:byte;
  CollectMode:boolean;
  Found:boolean;

procedure AnalyseUsedColor;
var
  Counter:word;
  Loop:word;
  Found:boolean;

begin
  UsedColor:=0;

  for Counter:=1 to ImageSize do
  begin
    Inc(ColorMap[Image^[Counter]+1]);

    Found:=False;

    for Loop:=1 to UsedColor do
      if UsedColorList[Loop]=Image^[Counter] then
      begin
        Found:=True;
        Break;
      end;

    if not Found then
    begin
      Inc(UsedColor);
      UsedColorList[UsedColor]:=Image^[Counter];
    end;
  end;
end;

procedure AnalyseUnusedColor;
var
  Counter:word;
  Loop:word;
  Found:boolean;

begin
  UnusedColor:=0;

  for Counter:=0 to 255 do
  begin
    Found:=False;

    for Loop:=1 to UsedColor do
      if UsedColorList[Loop]=Counter then
      begin
        Found:=True;
        Break;
      end;

    if not Found then
    begin
      Inc(UnusedColor);
      UnusedColorList[UnusedColor]:=Counter;
    end;
  end;
end;

procedure AnalyseFrequentlyUsedColor;
var
  Loop1,Loop2:word;
  Color:word;
  Index:byte;

begin
  for Color:=1 to 256 do
    FrequentlyUsedColorList[Color]:=Color-1;

  for Loop1:=2 to 256 do
  begin
    Color:=ColorMap[Loop1];
    Index:=FrequentlyUsedColorList[Loop1];

    Loop2:=Loop1-1;

    while (Color>ColorMap[Loop2]) and (Loop2>0) do
    begin
      ColorMap[Loop2+1]:=ColorMap[Loop2];
      FrequentlyUsedColorList[Loop2+1]:=FrequentlyUsedColorList[Loop2];

      Loop2:=Loop2-1;
    end;

    ColorMap[Loop2+1]:=Color;
    FrequentlyUsedColorList[Loop2+1]:=Index;
  end;
end;

function FindReferenceIndex(Code:byte):byte;
var
  Loop:word;

begin
  FindReferenceIndex:=0;

  for Loop:=1 to FrequencyTableSize do
    if FrequentlyUsedColorList[Loop]=Code then
    begin
      FindReferenceIndex:=UnusedColorList[Loop];
      Break;
    end;
end;

function FindColorIndex(Code:byte):byte;
var
  Loop:word;

begin
  FindColorIndex:=0;

  for Loop:=1 to FrequencyTableSize do
    if UnusedColorList[Loop]=Code then
    begin
      FindColorIndex:=FrequentlyUsedColorList[Loop];
      Break;
    end;
end;

procedure StoreColor;
begin
  Code:=Image^[Counter];
  BlockWrite(ExecutableFile,Code,1);
end;

procedure CompactColor;
var
  Loop:word;

begin
  Code:=FindReferenceIndex(Image^[Counter-1]);

  BlockWrite(ExecutableFile,Code,1);
  BlockWrite(ExecutableFile,Frequency,1);

  Frequency:=0;
end;

begin
  WriteLn('Image-to-Executable Generator');
  WriteLn('Developed by Boo Khan Ming');
  WriteLn;
  WriteLn('This generator is specifically designed for COMPO7 only,');
  WriteLn('and are specially optimized for supplied HUGI.RAW image.');
  WriteLn;

  (* Check command line parameter and available memory *)

  if ParamCount=0 then
  begin
    WriteLn('Usage: GENERATE <image filename>');
    Halt(255);
  end;

  if MaxAvail<SizeOf(Image^) then
  begin
    WriteLn('Insufficient memory.');
    Halt(1);
  end;

  (* Open source file *)

  {$I-}
  Assign(ImageFile,ParamStr(1));
  Reset(ImageFile,1);
  Assign(TemplateFile,TemplateFileName);
  Reset(TemplateFile,1);
  {$I+}
  if IOResult<>0 then
  begin
    WriteLn('Unable to open file.');
    Halt(2);
  end;

  New(Image);

  (* Read image palette and data *)

  {$I-}
  BlockRead(ImageFile,Palette,768);
  BlockRead(ImageFile,Image^,64000,ImageSize);
  {$I+}
  if (IOResult<>0) or (ImageSize<>64000) then
  begin
    WriteLn('Invalid file size.');
    Halt(3);
  end;

  (* Perform necessary colors analysis *)

  AnalyseUsedColor;
  AnalyseUnusedColor;
  AnalyseFrequentlyUsedColor;

  if UnusedColor=0 then
  begin
    WriteLn('Free color space unavailable.');
    WriteLn('Unable to compress file.');
    Halt(4);
  end;

  (* Create new destination file *)

  {$I-}
  Assign(ExecutableFile,ExecutableFileName);
  Rewrite(ExecutableFile,1);
  {$I+}
  if IOResult<>0 then
  begin
    WriteLn('Unable to create file.');
    Halt(5);
  end;

  (* Prepare frequency table *)

  if UnusedColor>UsedColor then
    FrequencyTableSize:=UsedColor
  else
    FrequencyTableSize:=UnusedColor;

  for Counter:=1 to FrequencyTableSize do
    FrequencyTable[Counter]:=(UnusedColorList[Counter] shl 8)+FrequentlyUsedColorList[Counter];

  WriteLn('Number of color(s) used:   ',UsedColor);
  WriteLn('Number of color(s) unused: ',UnusedColor);
  WriteLn;

  (* Compact palette *)

  Counter:=0;
  Loop:=0;

  repeat
    Inc(Counter);
    Inc(Loop);

    Code:=(Palette[Counter] shl 2)+(Palette[Counter+1] shr 4);
    CompactPalette[Loop]:=Code;

    Inc(Counter);
    Inc(Loop);

    Code:=(Palette[Counter] shl 4)+(Palette[Counter+1] shr 2);
    CompactPalette[Loop]:=Code;

    Inc(Counter);
    Inc(Loop);

    Code:=(Palette[Counter] shl 6)+(Palette[Counter+1] and $3f);
    CompactPalette[Loop]:=Code;

    Inc(Counter);
  until Counter=768;

  (* Build destination file *)

  BlockRead(TemplateFile,Buffer,SizeOf(Buffer),Size);
  BlockWrite(ExecutableFile,Buffer,Size-576-(FrequencyTableSize*2));
  BlockWrite(ExecutableFile,CompactPalette,576);
  BlockWrite(ExecutableFile,FrequencyTable,FrequencyTableSize*2);

  (* Analyse image data for possible compression *)

  Counter:=1;
  Frequency:=0;
  CollectMode:=False;

  repeat
    Found:=False;

    for Loop:=1 to FrequencyTableSize do
      if Image^[Counter]=FrequentlyUsedColorList[Loop] then
      begin
        Found:=True;
        Break;
      end;

    if CollectMode then
      if Image^[Counter]<>Image^[Counter-1] then
      begin
        CompactColor;
        CollectMode:=False;
      end;

    if (Found) or (CollectMode) then
    begin
      if (Image^[Counter]=Image^[Counter+1]) and (Frequency<252) then
      begin
        if (Image^[Counter+1]=Image^[Counter+2]) and (Frequency<252) then
        begin
          Inc(Frequency,3);
          Inc(Counter,3);

          CollectMode:=True;
        end
        else
        begin
          Inc(Frequency,2);
          Inc(Counter,2);

          CollectMode:=False;

          CompactColor;
        end;
      end
      else
        CollectMode:=False;

      if not CollectMode then
        if Frequency>0 then
        begin
          Inc(Frequency);
          Inc(Counter);

          CompactColor;
        end
        else
        begin
          StoreColor;
          Inc(Counter);
        end;
    end
    else
    begin
      StoreColor;
      Inc(Counter);
    end;

  until Counter>ImageSize;

  Seek(ExecutableFile,FileSize(ExecutableFile)-24);
  Truncate(ExecutableFile);

  WriteLn('Image compressed     - ',ParamStr(1));
  WriteLn('Executable generated - ',ExecutableFileName);

  Close(ImageFile);
  Close(TemplateFile);
  Close(ExecutableFile);

  Dispose(Image);
end.