 ; Title .... : Chut's Hugi#07 Decoder
 ; Version .. : 1.7c
 ; Author ... : Chut
 ; Country .. : Hungary
 ; Release .. : 30/05/99
 ; Tested ... : Cx486DX2-66

.486

Hugi7           Segment Use16
                Assume  cs:Hugi7,ds:Hugi7,es:Hugi7
                Org     0100h

Start:          mov     al,13h
                int     10h

SetPalette:     mov     bp,offset GetBit
                mov	si,offset CompressedDatas
                xchg    ax,bx
                mov     dx,03C8h
                out     dx,al                   ;first color
                inc     dx

                mov     cx,029Dh                ;669 compressed components
                xor     ebx,ebx
                mov     bl,dl                   ;EBX= B G R x
FillPalette:    push    bx
                mov     bl,63h
                xor     ax,ax
                call    SmallHuffmann           ;compressed component-delta
                pop     bx
                cmp     al,07h                  ;selection
                jne     short RelativeColor
                push    cx
                call    Get6inAX                ;overflow
                pop     cx
                DB      0A9h
RelativeColor:  add     al,bh                   ;delta correction
ColorOut:       out     dx,al
                mov     bh,al
NoComponent:    ror     ebx,8                   ;next component
                cmp     bh,dl
                je      short NoComponent
                loop    FillPalette

Palette224:     mov     cl,63h                  ;last 99 components
PlusColors:     cmp     cl,16h
                jnc     short ZeroComponent
                push    cx
                call    Get6inAX
                pop     cx
ZeroComponent:  out     dx,al
                loop    PlusColors

                push    8800h
                pop     es
                push    di
TextUnpacker:   mov     bl,78h                  ;normal stored data
                call    SmallHuffmann
                stosb
                call    bp
NextTag:        mov     ax,cx                   ;control bits
                jnc     short TextUnpacker
                call    bp
                mov     dx,0301h
                jnc     short PointerOK
                inc     dx
                call    bp
                jc      short ShortFrame
LongFrame:      shl     dx,2
ShortFrame:     mov     cl,dh
                call    GetinAXCycle
                jz      short PrintText         ;zero frame -> OK
                stc
                rcl     ax,1
PointerOK:      call    LoadingSize2
                mov     dh,00h
                add     cx,dx
TextSizeOK:     not     ax
                call    StringCopy
                jmp     short NextTag

PrintText:      xchg    ax,si                   ;mem -> video mem
                pop     si
                push    0A001h
                push    es
                pop     ds
                pop     es
                mov     di,0EAF8h
                mov     bl,13h
LetterCycle:    mov     bh,24h                  ;rotation
LineCycle:      mov     cl,10h
                rep     movsb
                sub     di,0150h
                dec     bh
                jnz     short LineCycle
                add     di,2D10h
                dec     bx
                jnz     short LetterCycle
                xchg    ax,si

GFXUnPacker:    push    es
                push    di
                push    ds
                push    cs
                pop     ds
                pop     es
MoveData:       mov     cl,07h                  ;normal stored data
                call    GetinAX
                cmp     al,20h                  ;compressed pixel
                jc      short Compressed
                call    bp
                rcl     al,1
                sub     al,40h
                cmp     al,10h
                jc      short MvDataOK
                add     al,10h
Compressed:     add     al,10h
MvDataOK:       jmp     short PushGFXByte

NearColor:      mov     bl,70h                  ;decompression - one pixel
                call    SmallHuffmann
                add     al,es:[di+0FF79h]

PushGFXByte:    cmp     al,22h
                je      short THE_END
                stosb
                or      dl,dh
                call    bp                      ;control bits
NextToken:      inc     bx
                mov     ax,cx
                jc      short NearColor
                call    bp
                jc      short FrameCodes
                or      dl,dh
                cmp     bl,bh
                jz      short MoveData
                call    bp
                jnc     short MoveData
                call    LoadingSize1
                dec     ax
                jmp     short CopyNullPtr
FrameCodes:     cmp     dl,al
                je      short DisableFFbit
                call    bp
                jnc     short FirstFrame
DisableFFbit:   mov     bl,6Ah
                call    SmallHuffmann           ;pointer selection
                dec     ax
                cbw
FirstFrame:     mov     dl,al
                add     ax,0FF79h
                call    LoadingSize2
CopyNullPtr:    call    StringCopy
                jmp     short NextToken

THE_END:        pop     si                      ;mem -> video mem
                push    es
                pop     ds
                pop     es
                mov     di,0D7Ch
                mov     al,0E1h
HorizontalStep: mov     cl,87h                  ;rotation
VerticalStep:   movsb
                add     di,013Fh
                loop    VerticalStep
                add     di,573Fh
                dec     ax
                jnz     short HorizontalStep
                int     16h
                mov     ax,0003h
                int     10h

 ;------------- Subroutines ------------

Get6inAX:       mov     cx,0006h
GetinAX:        xor     ax,ax
GetinAXCycle:   call    bp
                adc     ax,ax
                loop    GetinAXCycle
                ret

StringCopy:     xchg    ax,bx
CopyCycle:      mov     al,es:[bx+di]
                stosb
                loop    CopyCycle

GetBit:         shr     byte ptr [si],1
                jnz     short GetBitOK
                inc     si
                rcr     byte ptr [si],1
GetBitOK:       ret

LoadingSize2:   inc     cx
LoadSizeCycle:  call    bp
LoadingSize1:   rcl     cx,1
                call    bp
                jc      short LoadSizeCycle
                ret

NextBit:        inc     ax
SmallHuffmann:  mov     bh,02h
                call    bp
                jc      short NextBit           ;pointer selection
                xlatb
                call    bp
                jnc     short HighNibble        ;nibble selection
                shl     al,4
HighNibble:     sar     al,4
                ret

 ;------------- Data Area ---------------

HuffmannTable   DB      002h,0E1h,0F3h,07Ch,04Dh
                DB      05Ah,0B6h,020h,0F3h,0EDh
                DB      0CBh,0A9h,084h,0F1h,00Eh
                DB      02Dh,034h,0C7h,0B9h,05Ah
                DB      086h,0DBh,00Ch,0AEh,09Fh

CompressedDatas:

Hugi7           Ends
                End     Start