//Entry by DarK I to the Hugi Size Coding Competition 7. This code
//uses gif like compression

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

typedef unsigned char byte;

typedef struct
{
  short base;
  byte new;
} LZW_STRING;

typedef struct
{
  int pos;
  int bit_pos;
  byte data[255];
} BUFFER;

int num_bytes;
byte data[64768];
//This is the decompression code for the generated data ...
//(thank God for those hexeditors!!!)
//This code "allocates" 16768 bytes for the compressed image data
//if the image is not compressed enough, the file will not be generated.
//(hugi.raw IS compressed enough, I wouldn't be sure for anything else)
byte decompressor[302] = {
/*0000:*/ 0xB0, 0x13, 0xCD, 0x10, 0x68, 0x00, 0xA0, 0x07, 0xFC, 0xB9, 0x00, 0x03, 0xBA, 0xC8, 0x03, 0x30, 
/*0010:*/ 0xC0, 0xEE, 0x42, 0xBE, 0x2E, 0x02, 0xF3, 0x6E, 0x31, 0xFF, 0xE8, 0xAA, 0x00, 0x3D, 0x01, 0x01, 
/*0020:*/ 0x75, 0x03, 0xE9, 0x98, 0x00, 0x3D, 0x00, 0x01, 0x75, 0x18, 0xC7, 0x06, 0x29, 0x02, 0x02, 0x01, 
/*0030:*/ 0xC6, 0x06, 0x2B, 0x02, 0x09, 0xE8, 0x8F, 0x00, 0xA3, 0xAE, 0x83, 0xA2, 0xB0, 0x83, 0xAA, 0xE9, 
/*0040:*/ 0xD8, 0xFF, 0x50, 0x56, 0xBE, 0xAE, 0x73, 0x3B, 0x06, 0x29, 0x02, 0x75, 0x0A, 0xA1, 0xAE, 0x83, 
/*0050:*/ 0x8A, 0x1E, 0xB0, 0x83, 0x88, 0x1C, 0x46, 0x3D, 0x02, 0x01, 0x72, 0x12, 0x89, 0xC3, 0x8A, 0x8F, 
/*0060:*/ 0xAE, 0x63, 0x88, 0x0C, 0x46, 0xD1, 0xE3, 0x8B, 0x87, 0xAE, 0x43, 0xE9, 0xE9, 0xFF, 0xA2, 0xB0, 
/*0070:*/ 0x83, 0xAA, 0x81, 0xFE, 0xAE, 0x73, 0x74, 0x0A, 0x4E, 0x8A, 0x04, 0xAA, 0x81, 0xFE, 0xAE, 0x73, 
/*0080:*/ 0x75, 0xF6, 0x5E, 0x8B, 0x1E, 0x29, 0x02, 0x81, 0xFB, 0x00, 0x10, 0x73, 0x25, 0xA0, 0xB0, 0x83, 
/*0090:*/ 0x88, 0x87, 0xAE, 0x63, 0xA1, 0xAE, 0x83, 0xD1, 0xE3, 0x89, 0x87, 0xAE, 0x43, 0xD1, 0xEB, 0x43, 
/*00A0:*/ 0x8A, 0x0E, 0x2B, 0x02, 0xBA, 0x01, 0x00, 0xD3, 0xE2, 0x4A, 0x39, 0xD3, 0x76, 0x04, 0xFE, 0x06, 
/*00B0:*/ 0x2B, 0x02, 0x89, 0x1E, 0x29, 0x02, 0x58, 0xA3, 0xAE, 0x83, 0xE9, 0x5D, 0xFF, 0x31, 0xC0, 0xCD, 
/*00C0:*/ 0x16, 0xB8, 0x03, 0x00, 0xCD, 0x10, 0xC3, 0x80, 0x3E, 0x2C, 0x02, 0x00, 0x75, 0x0B, 0xE8, 0x47, 
/*00D0:*/ 0x00, 0xA2, 0xB1, 0x83, 0xC6, 0x06, 0x2C, 0x02, 0x08, 0x30, 0xFF, 0x8A, 0x1E, 0xB1, 0x83, 0xB1, 
/*00E0:*/ 0x08, 0x2A, 0x0E, 0x2C, 0x02, 0xD3, 0xEB, 0x8A, 0x0E, 0x2C, 0x02, 0x38, 0x0E, 0x2B, 0x02, 0x76, 
/*00F0:*/ 0x10, 0xE8, 0x24, 0x00, 0xA2, 0xB1, 0x83, 0xD3, 0xE0, 0x09, 0xC3, 0x80, 0xC1, 0x08, 0xE9, 0xEA, 
/*0100:*/ 0xFF, 0x2A, 0x0E, 0x2B, 0x02, 0x88, 0x0E, 0x2C, 0x02, 0x8A, 0x0E, 0x2B, 0x02, 0xBA, 0x01, 0x00, 
/*0110:*/ 0xD3, 0xE2, 0x4A, 0x21, 0xD3, 0x89, 0xD8, 0xC3, 0xA0, 0x2D, 0x02, 0x84, 0xC0, 0x75, 0x01, 0xAC, 
/*0120:*/ 0xFE, 0xC8, 0xA2, 0x2D, 0x02, 0xAC, 0x30, 0xE4, 0xC3, 0x02, 0x01, 0x09, 0x00, 0x00};

void clear_speed_buffer(short *speed_buffer)
{
  int i;
  for (i = 0; i < (256 * 4096); i++)
    speed_buffer[i] = -1;
}

void dump_buffer(BUFFER *b, FILE *f)
{
  int size;

  size = b->pos;
  if(b->bit_pos != 0)
    size ++;

  putc(size, f);
  num_bytes++;
  fwrite(b->data, 1, size, f);
  num_bytes += size;
}

void output(BUFFER *b, int bit_size, int code, FILE *f)
{
  int shift = b->bit_pos;

  do
  {
    if (shift >= 0)
    {
      if (b->bit_pos != 0)
        b->data[b->pos] = (byte)((code << shift) | b->data[b->pos]);
      else
        b->data[b->pos] = (byte)(code << shift);
    }
    else
    {
      if (b->bit_pos != 0)
        b->data[b->pos] = (byte)((code >> -shift) | b->data[b->pos]);
      else
        b->data[b->pos] = (byte)(code >> -shift);
    }
    if (bit_size + shift > 7)
    {
      b->bit_pos = 0;
      b->pos ++;
      shift -= 8;
      if (b->pos == 255)
      {
        dump_buffer(b, f);
	b->pos = 0;
	b->bit_pos = 0;
      }
      if ((bit_size + shift) <= 0)
        break;
    }
    else
    {
      b->bit_pos = bit_size + shift;
      break;
    }
  } while(1);
}

int main(void)
{
  FILE *f;
  int i, bit_size;
  LZW_STRING string_table[4096];
  int prefix;
  int input_pos = 0;
  int c;										/* current character */
  int empty_string;
  BUFFER buffer;
  short *speed_buffer;

  printf("Reading raw image file ...\n");
  f = fopen("hugi.raw", "rb");
  fread(data, 1, 64768, f);
  fclose(f);

  printf("Compressing image data ...\n");
  f = fopen("entry.com", "wb");
  if (!f)
    return errno;

  //Write decompression code
  printf(" Writting decompression code\n");
  for (i = 0; i < 302; i++)
    putc(decompressor[i], f);
  printf(" Writting palette\n");
  //Palette
  for(i = 0; i < 256; i ++)
  {
    putc(data[(i * 3)    ], f);
    putc(data[(i * 3) + 1], f);
    putc(data[(i * 3) + 2], f);
  }
  num_bytes = 768;
  printf(" Initializing decompression\n");
  for(i = 0; i < 256; i ++)
  {
    string_table[i].base = -1;
    string_table[i].new = i;
  }
  for(; i < 258; i ++)
  {
    string_table[i].base = -1;
    string_table[i].new = -1;
  }
  empty_string = 258;
  prefix = -1;
  bit_size = 9;

  buffer.pos = 0;
  buffer.bit_pos = 0;

  output(&buffer, bit_size, 256, f);

  speed_buffer = malloc(256 * 4096 * 2);
  clear_speed_buffer(speed_buffer);

  printf(" Compressing ...\n");
  while (1)
  {
    if (input_pos == 64000) //End of image
    {
      output(&buffer, bit_size, prefix, f);
      output(&buffer, bit_size, 257, f);
      dump_buffer(&buffer, f);
      putc(0, f);
      num_bytes++;
      break;
    }
    c = data[768 + input_pos];
    input_pos++;
    if (prefix == -1)
      i = c;
    else
      i = speed_buffer[prefix * 256 + c];
    if (i != -1)
      prefix = i;
    else
    {
      string_table[empty_string].base = prefix;
      string_table[empty_string].new = c;
      speed_buffer[prefix * 256 + c] = empty_string;
      empty_string ++;
      output(&buffer, bit_size, prefix, f);
      if (empty_string == (1 << bit_size) + 1)
        bit_size ++;
      if (empty_string == 4095)
      {
        output(&buffer, bit_size, 256, f);
        empty_string = 258;
	bit_size = 9;
        clear_speed_buffer(speed_buffer);
      }
      prefix = c;
    }
  }
  free(speed_buffer);
  putc(0x3b, f);
  num_bytes++;
  fclose(f);
  if (num_bytes > 16768)
  {
    printf("Raw image file could not be compressed enough.\n");
    printf("Compressed image size=%d bytes.\n", num_bytes);
    remove("entry.com");
    exit(1);
  }
  printf("Compression done.\nCompressed size: %d bytes.\nRatio:%3.2f.\n", num_bytes, (float) num_bytes / 647.680f);
  printf("entry.com was generated succesfully!\n");
  return 0;
}
